/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import org.apache.lucene.document.Fieldable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document {
    private Hashtable<String, Hashtable<String, Fieldable>> fieldablesTable = new Hashtable();
    private Hashtable<String, LinkedList<Fieldable>> readerMap = new Hashtable();

    public void add(Fieldable fieldable) {
        String strValue = fieldable.stringValue();
        if (strValue != null) {
            Hashtable<String, Object> fieldables = this.fieldablesTable.get(fieldable.name());
            if (fieldables == null) {
                fieldables = new Hashtable();
                this.fieldablesTable.put(fieldable.name(), fieldables);
            }
            fieldables.put(strValue, fieldable);
        } else {
            LinkedList<Object> fieldables = this.readerMap.get(fieldable.name());
            if (fieldables == null) {
                fieldables = new LinkedList();
                this.readerMap.put(fieldable.name(), fieldables);
            }
            fieldables.add(fieldable);
        }
    }

    public org.apache.lucene.document.Document createLuceneDocument() {
        org.apache.lucene.document.Document doc = new org.apache.lucene.document.Document();
        for (Hashtable<String, Fieldable> hashtable : this.fieldablesTable.values()) {
            for (Fieldable fieldable : hashtable.values()) {
                doc.add(fieldable);
            }
        }
        for (LinkedList linkedList : this.readerMap.values()) {
            for (Fieldable fieldable : linkedList) {
                doc.add(fieldable);
            }
        }
        return doc;
    }

    public Collection<String> getFieldValues(String field) {
        Hashtable<String, Fieldable> fieldables = this.fieldablesTable.get(field);
        if (fieldables != null) {
            return fieldables.keySet();
        }
        return Collections.emptyList();
    }

    public boolean containsField(String field) {
        return this.fieldablesTable.containsKey(field);
    }
}

