/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

public class DomainPathAnalyzer
extends Analyzer {
    public static final char PATH_START = '\u0001';
    public static final char PATH_SEPARATOR = '\u0002';
    public static final char TYPE_SEPARATOR = '\u0003';
    public static final char URI_SEPARATOR = '\u0004';
    public static final char ARCHIVE_SEPARATOR = '!';

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new DomainPathTokenizer(reader);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Tokenizer tokenizer = (Tokenizer)this.getPreviousTokenStream();
        if (tokenizer == null) {
            tokenizer = new DomainPathTokenizer(reader);
            this.setPreviousTokenStream(tokenizer);
        } else {
            tokenizer.reset(reader);
        }
        return tokenizer;
    }

    static class DomainPathTokenizer
    extends Tokenizer {
        private int offset = 0;
        private int bufferIndex = 0;
        private int dataLen = 0;
        private static final int MAX_WORD_LEN = 1024;
        private static final int IO_BUFFER_SIZE = 4096;
        private final char[] ioBuffer = new char[4096];
        private boolean typeCharFound = false;
        private boolean uriCharFound = false;

        public DomainPathTokenizer(Reader reader) {
            super(reader);
        }

        public void reset() throws IOException {
            super.reset();
            this.typeCharFound = false;
            this.uriCharFound = false;
        }

        public void reset(Reader input) throws IOException {
            super.reset(input);
            this.uriCharFound = false;
            this.typeCharFound = false;
        }

        public Token next(Token reusableToken) throws IOException {
            assert (reusableToken != null);
            reusableToken.clear();
            int length = 0;
            int start = this.bufferIndex;
            char[] buffer = reusableToken.termBuffer();
            boolean lowercaseCharFound = false;
            boolean digitFound = false;
            while (true) {
                if (this.bufferIndex >= this.dataLen) {
                    int incr;
                    this.offset += this.dataLen;
                    if (lowercaseCharFound || length == 0) {
                        incr = 0;
                    } else {
                        incr = 2;
                        this.ioBuffer[0] = this.ioBuffer[this.bufferIndex - 1];
                        this.ioBuffer[1] = this.ioBuffer[this.bufferIndex];
                    }
                    this.dataLen = this.input.read(this.ioBuffer, incr, this.ioBuffer.length - incr);
                    if (this.dataLen == -1) {
                        if (length <= 0) {
                            return null;
                        }
                        break;
                    }
                    this.bufferIndex = incr;
                    this.dataLen += incr;
                }
                char c = this.ioBuffer[this.bufferIndex++];
                boolean breakChar = true;
                boolean includeChar = false;
                if (c == '\u0001' || c == '\u0002') {
                    if (length == 0) {
                        includeChar = true;
                    } else {
                        --this.bufferIndex;
                    }
                    this.typeCharFound = false;
                    this.uriCharFound = false;
                } else if (c == '\u0003' && !this.typeCharFound || c == '\u0004' && !this.uriCharFound) {
                    length = 0;
                    breakChar = false;
                    lowercaseCharFound = false;
                    digitFound = false;
                } else if (Character.isDigit(c)) {
                    if (digitFound || length == 0) {
                        breakChar = false;
                        digitFound = true;
                    } else {
                        --this.bufferIndex;
                    }
                } else if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    if (digitFound) {
                        --this.bufferIndex;
                    } else if (Character.isLowerCase(c)) {
                        if (!lowercaseCharFound && length > 1) {
                            --length;
                            this.bufferIndex -= 2;
                        } else {
                            lowercaseCharFound = true;
                            breakChar = false;
                        }
                    } else if (!lowercaseCharFound) {
                        breakChar = false;
                    } else {
                        --this.bufferIndex;
                    }
                }
                if (!breakChar || includeChar) {
                    if (length == 0) {
                        start = this.offset + this.bufferIndex - 1;
                    } else if (length == buffer.length) {
                        buffer = reusableToken.resizeTermBuffer(1 + length);
                    }
                    if (c == '\u0003' && !this.typeCharFound) {
                        this.typeCharFound = true;
                    } else if (c == '\u0004' && !this.uriCharFound) {
                        this.typeCharFound = true;
                    } else {
                        buffer[length++] = Character.toLowerCase(c);
                    }
                    if (length != 1024 && (!breakChar || length <= 0)) continue;
                    break;
                }
                if (length > 0) break;
            }
            reusableToken.setTermLength(length);
            reusableToken.setStartOffset(start);
            reusableToken.setEndOffset(start + length);
            return reusableToken;
        }
    }
}

