/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DomainSearch;
import org.apache.tuscany.sca.domain.search.IndexException;
import org.apache.tuscany.sca.domain.search.Result;
import org.apache.tuscany.sca.domain.search.impl.Document;
import org.apache.tuscany.sca.domain.search.impl.DomainSearchAnalyzer;
import org.apache.tuscany.sca.domain.search.impl.DomainSearchDocumentProcessorsMap;
import org.apache.tuscany.sca.domain.search.impl.DomainSearchResultFactory;
import org.apache.tuscany.sca.domain.search.impl.DomainSearchResultProcessor;
import org.apache.tuscany.sca.domain.search.impl.HighlightingUtil;
import org.osoa.sca.annotations.AllowsPassByReference;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Scope;

@Scope(value="COMPOSITE")
public class DomainSearchImpl
implements DomainSearch {
    @Property
    public String indexDirectoryPath;
    private Directory dir;
    private Analyzer analyzer = new DomainSearchAnalyzer();
    private MultiFieldQueryParser qp = new MultiFieldQueryParser(new String[]{"artifact", "binding", "component", "composite", "contribution", "exportedby", "filecontent", "implements", "importedby", "includedby", "propertykey", "reference", "referenceinterfacecallback", "referenceinterface", "referencename", "service", "serviceinterfacecallback", "serviceinterface", "servicename", "type", "propertyvalue"}, this.analyzer);

    public DomainSearchImpl() {
        this.qp.setAllowLeadingWildcard(true);
    }

    private Directory getIndexDirectory() throws IOException {
        if (this.dir == null) {
            if (this.indexDirectoryPath == null || this.indexDirectoryPath.length() == 0) {
                this.dir = new RAMDirectory();
            } else {
                try {
                    this.dir = FSDirectory.getDirectory((File)new File(this.indexDirectoryPath), (LockFactory)new SimpleFSLockFactory(this.indexDirectoryPath));
                }
                catch (IOException e) {
                    System.err.println("Could not open index at " + this.indexDirectoryPath);
                    throw e;
                }
            }
        }
        return this.dir;
    }

    @AllowsPassByReference
    public void addContribution(Contribution contribution) throws IndexException {
        IndexWriter indexWriter = null;
        try {
            indexWriter = new IndexWriter(this.getIndexDirectory(), this.analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
            this.contributionAdded(contribution, indexWriter);
            indexWriter.commit();
        }
        catch (Exception e) {
            if (indexWriter != null) {
                try {
                    indexWriter.rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IndexException(e.getMessage(), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @AllowsPassByReference
    public void removeContribution(Contribution contribution) throws IndexException {
        IndexWriter indexWriter = null;
        if (this.indexExists()) {
            try {
                indexWriter = new IndexWriter(this.getIndexDirectory(), this.analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
                this.contributionRemoved(contribution, indexWriter);
                indexWriter.commit();
            }
            catch (Exception e) {
                if (indexWriter != null) {
                    try {
                        indexWriter.rollback();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                throw new IndexException(e.getMessage(), e);
            }
            finally {
                if (indexWriter != null) {
                    try {
                        indexWriter.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private void contributionRemoved(Contribution contribution, IndexWriter indexWriter) throws IndexException {
        String contributionURI = contribution.getURI();
        StringBuilder sb = new StringBuilder("parent");
        sb.append(":\"");
        sb.append('\u0001');
        sb.append(contributionURI);
        sb.append("\" OR ");
        sb.append("contribution");
        sb.append(":\"");
        sb.append(contributionURI);
        sb.append('\"');
        try {
            Query query = this.qp.parse(sb.toString());
            indexWriter.deleteDocuments(query);
        }
        catch (ParseException e) {
        }
        catch (CorruptIndexException ex) {
            throw new IndexException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IndexException(ex.getMessage(), ex);
        }
    }

    private void contributionAdded(Contribution contribution, IndexWriter indexWriter) throws IndexException {
        DomainSearchDocumentProcessorsMap docProcessors = new DomainSearchDocumentProcessorsMap();
        DocumentMap docs = new DocumentMap();
        try {
            docProcessors.process(docProcessors, docs, contribution, null, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Document doc : docs.values()) {
            org.apache.lucene.document.Document luceneDoc = doc.createLuceneDocument();
            try {
                indexWriter.addDocument(luceneDoc);
            }
            catch (CorruptIndexException e) {
                throw new IndexException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new IndexException(e.getMessage(), e);
            }
        }
    }

    @AllowsPassByReference
    public void updateContribution(Contribution oldContribution, Contribution contribution) throws IndexException {
        IndexWriter indexWriter = null;
        try {
            indexWriter = new IndexWriter(this.getIndexDirectory(), this.analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
            this.contributionRemoved(oldContribution, indexWriter);
            this.contributionAdded(contribution, indexWriter);
            indexWriter.commit();
        }
        catch (Exception e) {
            if (indexWriter != null) {
                try {
                    indexWriter.rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IndexException(e.getMessage(), e);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Result[] parseAndSearch(String searchQuery, boolean highlight) throws IndexException, ParseException {
        return this.search(this.qp.parse(searchQuery), highlight);
    }

    public Result[] search(Query searchQuery, boolean highlight) throws IndexException {
        try {
            IndexSearcher searcher = new IndexSearcher(this.getIndexDirectory());
            DomainSearchResultProcessor resultProcessor = new DomainSearchResultProcessor(new DomainSearchResultFactory());
            TopDocs topDocs = searcher.search(searchQuery, 1000);
            int indexed = 0;
            HashSet<String> set = new HashSet<String>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                org.apache.lucene.document.Document luceneDocument = searcher.doc(scoreDoc.doc);
                resultProcessor.process(luceneDocument, null);
                ++indexed;
                set.add(luceneDocument.toString());
            }
            Result[] results = resultProcessor.createResultRoots();
            if (highlight) {
                for (Result result : results) {
                    HighlightingUtil.highlightResult(result, searchQuery);
                }
            }
            return results;
        }
        catch (CorruptIndexException ex) {
            throw new IndexException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IndexException(ex.getMessage(), ex);
        }
    }

    public String highlight(String field, String text, String searchQuery) throws ParseException {
        Query query = this.qp.parse(searchQuery);
        return HighlightingUtil.highlight(field, query, text);
    }

    public boolean indexExists() {
        if ((this.indexDirectoryPath == null || this.indexDirectoryPath.length() == 0) && this.dir == null) {
            return false;
        }
        return this.dir != null || IndexReader.indexExists((File)new File(this.indexDirectoryPath));
    }
}

