/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.util.LinkedList;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;
import org.apache.tuscany.sca.domain.search.impl.FileContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDocumentProcessor
extends LinkedList<DocumentProcessor>
implements DocumentProcessor {
    private static final long serialVersionUID = 7843338343970738591L;

    @Override
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document doc, String parent) {
        if (object instanceof FileContent) {
            FileContent file = (FileContent)object;
            if (!file.isLeaf()) {
                if (doc == null) {
                    doc = documents.get("filecontent" + file.getPath());
                }
                return doc;
            }
            for (DocumentProcessor processor : this) {
                Document newDoc = processor.process(this, documents, file, doc, parent);
                if (newDoc == null) continue;
                return newDoc;
            }
        }
        return doc;
    }

    @Override
    public Object getDocumentKey(Object object) {
        if (object instanceof FileContent) {
            FileContent file = (FileContent)object;
            String path = file.getPath();
            if (path != null && path.length() == 0) {
                return null;
            }
            return "filecontent" + path;
        }
        throw new IllegalArgumentException();
    }
}

