/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.tuscany.sca.domain.search.Result;
import org.apache.tuscany.sca.domain.search.impl.DomainSearchAnalyzer;
import org.apache.tuscany.sca.domain.search.impl.DomainSearchFormatter;

public final class HighlightingUtil {
    public static void highlightResult(Result result, Query query) {
        HighlightingUtil.highlightResult(result, query, (Fragmenter)new SimpleFragmenter(70));
    }

    public static void highlightResult(Result result, Query query, Fragmenter fragmenter) {
        String highlightedText;
        Map<String, Result> contents = result.getContents();
        if (contents != null) {
            for (Result content : contents.values()) {
                HighlightingUtil.highlightResult(content, query, fragmenter);
            }
        }
        if ((highlightedText = HighlightingUtil.bestFragmentHighlighted(result.getField(), query, result.getValue(), fragmenter)) != null && highlightedText.length() > 0) {
            result.setValue(highlightedText);
        }
    }

    public static String highlight(String field, Query query, String text) {
        String highlightedText = HighlightingUtil.bestFragmentHighlighted(field, query, text, (Fragmenter)new NullFragmenter());
        if (highlightedText == null || text.length() >= highlightedText.length()) {
            return text;
        }
        return highlightedText;
    }

    public static String bestFragmentHighlighted(String field, Query query, String text) throws IOException {
        return HighlightingUtil.bestFragmentHighlighted(field, query, text, (Fragmenter)new SimpleFragmenter(100));
    }

    public static String bestFragmentHighlighted(String field, Query query, String text, Fragmenter fragmenter) {
        try {
            CachingTokenFilter tokenStream = new CachingTokenFilter(new DomainSearchAnalyzer().tokenStream(field, new StringReader(text)));
            QueryScorer scorer = new QueryScorer(query, field, "");
            scorer.init((TokenStream)tokenStream);
            Highlighter highlighter = new Highlighter((Formatter)new DomainSearchFormatter(), (Scorer)scorer);
            highlighter.setTextFragmenter(fragmenter);
            tokenStream.reset();
            try {
                return highlighter.getBestFragments((TokenStream)tokenStream, text, 2, " ... ");
            }
            catch (InvalidTokenOffsetsException e) {
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return "";
    }

    public static String replaceHighlightMarkupBy(CharSequence text, String startHighlight, String endHighlight) {
        StringBuilder sb;
        block12: {
            int j;
            int end;
            int start;
            block11: {
                sb = new StringBuilder();
                start = 0;
                end = 0;
                for (int i = 0; i < text.length(); ++i) {
                    int j2;
                    char c = text.charAt(i);
                    if (start > 0) {
                        if (c == "\u0005\u0005\u0006".charAt(start)) {
                            if (++start != "\u0005\u0005\u0006".length()) continue;
                            sb.append(startHighlight);
                            start = 0;
                            continue;
                        }
                        for (j2 = 0; j2 < start; ++j2) {
                            sb.append("\u0005\u0005\u0006".charAt(j2));
                        }
                        start = 0;
                        continue;
                    }
                    if (end > 0) {
                        if (c == "\u0006\u0005\u0005".charAt(end)) {
                            if (++end != "\u0006\u0005\u0005".length()) continue;
                            sb.append(endHighlight);
                            end = 0;
                            continue;
                        }
                        for (j2 = 0; j2 < end; ++j2) {
                            sb.append("\u0006\u0005\u0005".charAt(j2));
                        }
                        end = 0;
                        continue;
                    }
                    if (c == "\u0005\u0005\u0006".charAt(0)) {
                        start = 1;
                        continue;
                    }
                    if (c == "\u0006\u0005\u0005".charAt(0)) {
                        end = 1;
                        continue;
                    }
                    sb.append(c);
                }
                if (start <= 0) break block11;
                for (j = 0; j < start; ++j) {
                    sb.append("\u0005\u0005\u0006".charAt(j));
                }
                break block12;
            }
            if (end <= 0) break block12;
            for (j = 0; j < start; ++j) {
                sb.append("\u0006\u0005\u0005".charAt(j));
            }
        }
        return sb.toString();
    }
}

