/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class NamingTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 4096;
    private final char[] ioBuffer = new char[4096];

    public NamingTokenizer(Reader reader) {
        super(reader);
    }

    public Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        reusableToken.clear();
        int length = 0;
        int start = this.bufferIndex;
        char[] buffer = reusableToken.termBuffer();
        boolean lowercaseCharFound = false;
        boolean digitFound = false;
        while (true) {
            if (this.bufferIndex >= this.dataLen) {
                int incr;
                this.offset += this.dataLen;
                if (lowercaseCharFound || length == 0) {
                    incr = 0;
                } else {
                    incr = 2;
                    this.ioBuffer[0] = this.ioBuffer[this.bufferIndex - 1];
                    this.ioBuffer[1] = this.ioBuffer[this.bufferIndex];
                }
                this.dataLen = this.input.read(this.ioBuffer, incr, this.ioBuffer.length - incr);
                if (this.dataLen == -1) {
                    if (length <= 0) {
                        return null;
                    }
                    break;
                }
                this.bufferIndex = incr;
                this.dataLen += incr;
            }
            char c = this.ioBuffer[this.bufferIndex++];
            boolean breakChar = true;
            if (Character.isDigit(c)) {
                if (digitFound || length == 0) {
                    breakChar = false;
                    digitFound = true;
                } else {
                    --this.bufferIndex;
                }
            } else if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                if (digitFound) {
                    --this.bufferIndex;
                } else if (Character.isLowerCase(c)) {
                    if (!lowercaseCharFound && length > 1) {
                        --length;
                        this.bufferIndex -= 2;
                    } else {
                        lowercaseCharFound = true;
                        breakChar = false;
                    }
                } else if (!lowercaseCharFound) {
                    breakChar = false;
                } else {
                    --this.bufferIndex;
                }
            }
            if (!breakChar) {
                if (length == 0) {
                    start = this.offset + this.bufferIndex - 1;
                } else if (length == buffer.length) {
                    buffer = reusableToken.resizeTermBuffer(1 + length);
                }
                buffer[length++] = Character.toLowerCase(c);
                if (length != 255) continue;
                break;
            }
            if (length > 0) break;
        }
        reusableToken.setTermLength(length);
        reusableToken.setStartOffset(start);
        reusableToken.setEndOffset(start + length);
        return reusableToken;
    }
}

