/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParentField
implements Serializable {
    private static final long serialVersionUID = -2090538050273088026L;
    private final List<ParentFieldElement> elements;

    public ParentField(String parentFieldValue) {
        int length = parentFieldValue.length();
        if (length == 0) {
            this.elements = Collections.emptyList();
            return;
        }
        this.elements = new ArrayList<ParentFieldElement>();
        ParentFieldElement element = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = parentFieldValue.charAt(i);
            if (c == '\u0002' || c == '\u0001') {
                if (sb.length() <= 0 && element == null) continue;
                if (element == null) {
                    element = new ParentFieldElement();
                }
                if (element.type == null) {
                    element.type = "";
                }
                if (element.uri == null) {
                    element.uri = element.name = sb.toString();
                } else {
                    element.name = sb.toString();
                }
                sb.setLength(0);
                this.elements.add(element);
                element = null;
                continue;
            }
            if (c == '\u0003') {
                if (element == null) {
                    element = new ParentFieldElement();
                }
                element.type = sb.toString();
                sb.setLength(0);
                continue;
            }
            if (c == '\u0004') {
                if (element == null) {
                    element = new ParentFieldElement();
                }
                element.uri = sb.toString();
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0 || element != null) {
            if (element == null) {
                element = new ParentFieldElement();
            }
            if (element.type == null) {
                element.type = "";
            }
            if (element.uri == null) {
                element.uri = element.name = sb.toString();
            } else {
                element.name = sb.toString();
            }
            sb.setLength(0);
            this.elements.add(element);
            element = null;
        }
    }

    public static String getURIPath(ParentField parentField) {
        return ParentField.getURIPath(parentField, System.getProperty("file.separator"));
    }

    public static String getURIPath(ParentField parentField, String pathSeparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(pathSeparator);
        int elementsCount = parentField.getElementsCount();
        for (int i = 0; i < elementsCount; ++i) {
            sb.append(parentField.getElementName(i));
            sb.append(pathSeparator);
        }
        if (sb.length() > pathSeparator.length()) {
            sb.setLength(sb.length() - pathSeparator.length());
        }
        return sb.toString();
    }

    public static int getParentElementsCount(String parent) {
        int length = parent.length();
        if (length == 0) {
            return 0;
        }
        boolean pathSeparatorBefore = true;
        int count = 1;
        for (int i = 0; i < length - 1; ++i) {
            char c = parent.charAt(i);
            if (c == '\u0002' && !pathSeparatorBefore) {
                pathSeparatorBefore = true;
                ++count;
                continue;
            }
            pathSeparatorBefore = false;
        }
        return count;
    }

    public int getElementsCount() {
        return this.elements.size();
    }

    public String getElementType(int index) {
        return this.elements.get((int)index).type;
    }

    public String getElementURI(int index) {
        return this.elements.get((int)index).uri;
    }

    public String getElementName(int index) {
        return this.elements.get((int)index).name;
    }

    private static final class ParentFieldElement {
        String type;
        String uri;
        String name;

        private ParentFieldElement() {
        }
    }
}

