/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.lang.reflect.Array;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;

public class PropertyDocumentProcessor
implements DocumentProcessor {
    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document doc, String parent) {
        if (object instanceof Property) {
            Property property = (Property)object;
            String name = property.getName();
            if (name != null && name.length() > 0) {
                Object value;
                if (doc == null) {
                    doc = documents.get(name);
                }
                if ((value = property.getValue()).getClass().isArray()) {
                    int arraySize = Array.getLength(value);
                    for (int i = 0; i < arraySize; ++i) {
                        Object arrayValue = Array.get(value, i);
                        doc.add((Fieldable)new Field("propertyvalue", arrayValue.toString(), Field.Store.YES, Field.Index.ANALYZED));
                    }
                } else {
                    doc.add((Fieldable)new Field("propertyvalue", value.toString(), Field.Store.YES, Field.Index.ANALYZED));
                }
                return doc == null ? FAKE_DOCUMENT : doc;
            }
            return FAKE_DOCUMENT;
        }
        throw new IllegalArgumentException();
    }

    public Object getDocumentKey(Object object) {
        return null;
    }
}

