/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.domain.search.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultImpl
implements Result {
    private static final long serialVersionUID = 7084570994751217396L;
    private Result container;
    private HashMap<String, Result> contents;
    private String value;
    private String field;

    public ResultImpl() {
    }

    public ResultImpl(String field, String value) {
        this.setValue(value);
        this.setField(field);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public Result getContainer() {
        return this.container;
    }

    @Override
    public Map<String, Result> getContents() {
        if (this.contents == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.contents);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setContainer(Result container) {
        if (container != this.container) {
            if (this.container != null) {
                this.container.removeContent(this);
            }
            this.container = container;
            if (container != null) {
                container.addContent(this);
            }
        }
    }

    public boolean equals(Object obj) {
        Result artifactResult;
        if (obj instanceof Result && ((artifactResult = (Result)obj).getValue() == this.value || this.value != null && this.value.equals(artifactResult.getValue())) && (artifactResult.getContainer() == this.container || this.container != null && this.container.equals(artifactResult.getContainer()))) {
            Map<String, Result> contents = artifactResult.getContents();
            if (this.contents == null) {
                return contents.isEmpty();
            }
            if (this.contents.equals(contents)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addContent(Result artifactResult) {
        this.internalGetContents().put(artifactResult.getValue(), artifactResult);
        if (artifactResult.getContainer() != this) {
            artifactResult.setContainer(this);
        }
    }

    private HashMap<String, Result> internalGetContents() {
        if (this.contents == null) {
            this.contents = new HashMap();
        }
        return this.contents;
    }

    @Override
    public void removeContent(Result artifactResult) {
        if (this.contents != null) {
            this.contents.remove(artifactResult);
            artifactResult.setContainer(null);
            if (this.contents.isEmpty()) {
                this.contents = null;
            }
        }
    }

    public int hashCode() {
        int hash = 11;
        hash = hash * 31 + (this.container == null ? 7 : this.container.hashCode());
        hash = hash * 31 + (this.contents == null || this.contents.isEmpty() ? 13 : this.contents.hashCode());
        hash = hash * 31 + (this.value == null ? 17 : this.value.hashCode());
        return hash;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        Method[] methods;
        StringBuilder sb = new StringBuilder("<");
        Result container = this.getContainer();
        sb.append(this.getClass().getName()).append(" name='").append(this.getValue()).append("' container='").append(container != null ? container.getValue() : null).append("'>\n");
        for (Method method : methods = this.getClass().getMethods()) {
            String methodName = method.getName();
            if (method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || !methodName.startsWith("get") || "getName".equals(methodName) || "getContainer".equals(methodName)) continue;
            try {
                Object returnedObj = method.invoke((Object)this, new Object[0]);
                sb.append('\t');
                if (returnedObj instanceof Map) {
                    sb.append("<collection type='").append(returnedObj.getClass().getGenericInterfaces()[1]).append("'>\n");
                    for (Object obj : ((Map)returnedObj).values()) {
                        sb.append("\t\t").append(obj.toString()).append("\n");
                    }
                    sb.append("\t</collection>\n");
                    continue;
                }
                if (returnedObj instanceof Collection) {
                    sb.append("<collection type='").append(returnedObj.getClass().getGenericInterfaces()[0]).append("'>\n");
                    for (Object obj : (Collection)returnedObj) {
                        sb.append("\t\t").append(obj.toString()).append("\n");
                    }
                    sb.append("\t</collection>\n");
                    continue;
                }
                if (returnedObj.getClass().isArray()) {
                    sb.append("<array type='").append(returnedObj.getClass().getComponentType()).append("'>\n");
                    int length = Array.getLength(returnedObj);
                    for (int i = 0; i < length; ++i) {
                        sb.append("\t\t").append(Array.get(returnedObj, i).toString()).append("\n");
                    }
                    sb.append("\t</array>\n");
                    continue;
                }
                sb.append('\t').append(returnedObj).append('\n');
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        sb.append("</").append(this.getClass().getName()).append(">");
        return sb.toString();
    }
}

