/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import org.apache.tuscany.sca.domain.search.impl.DefaultFileContent;
import org.apache.tuscany.sca.domain.search.impl.FileContent;
import org.apache.tuscany.sca.domain.search.impl.SystemFileContent;
import org.apache.tuscany.sca.domain.search.impl.ZipFileContent;

public class WrappedFileContent
implements FileContent {
    private final FileContent fileContent;

    public WrappedFileContent(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            JarURLConnection jarConn = (JarURLConnection)url.openConnection();
            String file = url.getFile();
            file = file.substring(file.lastIndexOf(33) + 1);
            this.fileContent = ZipFileContent.createZipFileContent(jarConn.getJarFile(), file);
        } else {
            this.fileContent = protocol.equals("file") ? new SystemFileContent(new File(url.getFile())) : new DefaultFileContent(url);
        }
    }

    public FileContent[] getChildren() {
        return this.fileContent.getChildren();
    }

    public InputStream getInputStream() throws IOException {
        return this.fileContent.getInputStream();
    }

    public String getName() {
        return this.fileContent.getName();
    }

    public String getPath() {
        return this.fileContent.getPath();
    }

    public boolean isLeaf() {
        return this.fileContent.isLeaf();
    }
}

