/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tuscany.sca.domain.search.DocumentMap;
import org.apache.tuscany.sca.domain.search.DocumentProcessor;
import org.apache.tuscany.sca.domain.search.impl.Document;
import org.apache.tuscany.sca.domain.search.impl.SystemFileContent;
import org.apache.tuscany.sca.domain.search.impl.ZipFileContent;

public class ZipDocumentProcessor
implements DocumentProcessor {
    public Object getDocumentKey(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            String path = file.getPath();
            if (path != null && path.length() == 0) {
                return null;
            }
            return path;
        }
        throw new IllegalArgumentException();
    }

    public Document process(DocumentProcessor parentProcessor, DocumentMap documents, Object object, Document document, String parent) {
        if (object instanceof SystemFileContent) {
            SystemFileContent file = (SystemFileContent)object;
            try {
                ZipFileContent[] zipFiles;
                ZipFile zip = new ZipFile(file.getFile());
                if (document == null) {
                    document = documents.get(file.getPath());
                }
                parent = parent + "\u0002artifact\u0003jar:file:" + file.getPath() + '!' + '/' + file.getName() + '\u0004' + file.getName();
                document.add((Fieldable)new Field("artifact", file.getName(), Field.Store.YES, Field.Index.ANALYZED));
                for (ZipFileContent zipFile : zipFiles = ZipFileContent.createZipFileContent(zip)) {
                    parentProcessor.process(parentProcessor, documents, zipFile, document, parent);
                }
                return document;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }
}

