/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.search.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tuscany.sca.domain.search.impl.FileContent;

public class ZipFileContent
implements FileContent {
    private final ZipFile file;
    private final ZipEntry entry;
    private FileContent[] children;

    private ZipFileContent(ZipFile file, ZipEntry entry) {
        this.file = file;
        this.entry = entry;
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream(this.entry);
    }

    public String getPath() {
        return this.file.getName() + '!' + '/' + this.entry.getName();
    }

    public FileContent[] getChildren() {
        return this.children;
    }

    public String getName() {
        return this.entry.getName();
    }

    public boolean isLeaf() {
        return !this.entry.isDirectory();
    }

    public static ZipFileContent[] createZipFileContent(ZipFile file) {
        Enumeration<? extends ZipEntry> entries = file.entries();
        if (!entries.hasMoreElements()) {
            return null;
        }
        HashMap<String, ZipMap> roots = new HashMap<String, ZipMap>();
        do {
            ZipEntry entry;
            String name;
            if ((name = (entry = entries.nextElement()).getName()).length() <= 0) continue;
            String[] path = name.split("/");
            ZipMap current = (ZipMap)roots.get(path[0]);
            if (current == null) {
                current = new ZipMap();
                roots.put(path[0], current);
                if (path.length == 1) {
                    current.setEntry(file, entry);
                    continue;
                }
            }
            for (int i = 1; i < path.length - 1; ++i) {
                ZipMap actual = (ZipMap)current.get(path[i]);
                if (actual == null) {
                    actual = new ZipMap();
                    current.put(path[i], actual);
                }
                current = actual;
            }
            ZipMap entryMap = (ZipMap)current.get(path[path.length - 1]);
            if (entryMap == null) {
                entryMap = new ZipMap();
                current.put(path[path.length - 1], entryMap);
            }
            entryMap.setEntry(file, entry);
        } while (entries.hasMoreElements());
        for (ZipMap map : roots.values()) {
            ZipFileContent.createZipFileContentChildren(map);
        }
        ZipFileContent[] ret = new ZipFileContent[roots.size()];
        int i = 0;
        for (ZipMap rootMap : roots.values()) {
            ret[i++] = rootMap.zipContent;
        }
        return ret;
    }

    public static ZipFileContent createZipFileContent(ZipFile file, String filePath) {
        Enumeration<? extends ZipEntry> entries = file.entries();
        if (!entries.hasMoreElements()) {
            return null;
        }
        int beginIndex = filePath.charAt(0) == '/' ? 1 : 0;
        ZipMap root = new ZipMap();
        int endIndex = filePath.length() > 1 && filePath.charAt(filePath.length() - 1) == '/' ? filePath.length() - 1 : filePath.length();
        filePath = filePath.substring(beginIndex, endIndex);
        do {
            ZipEntry entry;
            String name;
            if ((name = (entry = entries.nextElement()).getName()).length() <= 0) continue;
            endIndex = name.charAt(name.length() - 1) == '/' ? 1 : 0;
            if (name.length() - endIndex == filePath.length()) {
                root.setEntry(file, entry);
                continue;
            }
            if (filePath.length() != 0 && (!name.startsWith(filePath) || name.charAt(filePath.length()) != '/')) continue;
            name = name.substring(filePath.length());
            String[] path = name.split("/");
            ZipMap current = root;
            if (path.length <= 0) continue;
            for (int i = path[0].length() == 0 ? 1 : 0; i < path.length - 1; ++i) {
                ZipMap actual = (ZipMap)current.get(path[i]);
                if (actual == null) {
                    actual = new ZipMap();
                    current.put(path[i], actual);
                }
                current = actual;
            }
            ZipMap entryMap = (ZipMap)current.get(path[path.length - 1]);
            if (entryMap == null) {
                entryMap = new ZipMap();
                current.put(path[path.length - 1], entryMap);
            }
            entryMap.setEntry(file, entry);
        } while (entries.hasMoreElements());
        ZipFileContent.createZipFileContentChildren(root);
        return root.zipContent;
    }

    private static void createZipFileContentChildren(ZipMap map) {
        ZipFileContent[] children = new ZipFileContent[map.size()];
        int i = 0;
        for (ZipMap childMap : map.values()) {
            if (childMap.zipContent == null) {
                throw new RuntimeException("could not load zip file hierarchy for file: " + map.zipContent.file);
            }
            children[i++] = childMap.zipContent;
            ZipFileContent.createZipFileContentChildren(childMap);
        }
        map.zipContent.children = children;
    }

    public String toString() {
        return this.file.getName() + '/' + this.entry.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipMap
    extends HashMap<String, ZipMap> {
        private static final long serialVersionUID = 6514645087432837480L;
        ZipFileContent zipContent;

        private ZipMap() {
        }

        void setEntry(ZipFile zipFile, ZipEntry entry) {
            this.zipContent = new ZipFileContent(zipFile, entry);
        }

        ZipFileContent[] getChildren() {
            ZipFileContent[] ret = new ZipFileContent[this.size()];
            int i = 0;
            for (ZipMap actual : this.values()) {
                ret[i++] = actual.zipContent;
            }
            return ret;
        }
    }
}

