/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscoverer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiServiceDiscoverer
implements ServiceDiscoverer {
    private static final Logger logger = Logger.getLogger(OSGiServiceDiscoverer.class.getName());
    private BundleContext context;
    private ClassLoader classLoader;

    public OSGiServiceDiscoverer(BundleContext context) {
        this.context = context;
        this.classLoader = new ClassLoaderImpl();
    }

    public static String toString(Bundle b) {
        StringBuffer sb = new StringBuffer();
        sb.append(b.getBundleId()).append(" ").append(b.getSymbolicName());
        int s = b.getState();
        if ((s & 1) != 0) {
            sb.append(" UNINSTALLED");
        }
        if ((s & 2) != 0) {
            sb.append(" INSTALLED");
        }
        if ((s & 4) != 0) {
            sb.append(" RESOLVED");
        }
        if ((s & 8) != 0) {
            sb.append(" STARTING");
        }
        if ((s & 0x10) != 0) {
            sb.append(" STOPPING");
        }
        if ((s & 0x20) != 0) {
            sb.append(" ACTIVE");
        }
        return sb.toString();
    }

    protected static Map<String, String> parseServiceDeclaration(String declaration) {
        String value;
        String key;
        HashMap<String, String> attributes = new HashMap<String, String>();
        int index = declaration.indexOf(59);
        if (index != -1) {
            attributes.put("class", declaration.substring(0, index).trim());
            declaration = declaration.substring(index);
        } else {
            int j = declaration.indexOf(61);
            if (j == -1) {
                attributes.put("class", declaration.trim());
                return attributes;
            }
            declaration = ";" + declaration;
        }
        StringTokenizer tokens = new StringTokenizer(declaration);
        while (tokens.hasMoreTokens() && (key = tokens.nextToken("=").substring(1).trim()) != null && (value = tokens.nextToken(",").substring(1).trim()) != null) {
            attributes.put(key, value);
        }
        return attributes;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public ClassLoader getContextClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<ServiceDeclaration> discover(String serviceName, boolean firstOnly) {
        boolean debug = logger.isLoggable(Level.FINE);
        HashSet<ServiceDeclaration> descriptors = new HashSet<ServiceDeclaration>();
        serviceName = "META-INF/services/" + serviceName;
        Bundle[] arr$ = this.context.getBundles();
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            Bundle bundle = arr$[i$];
            final URL url = bundle.getEntry(serviceName);
            if (url != null) {
                if (debug) {
                    logger.fine("Reading service provider file: " + url.toExternalForm());
                }
                try {
                    InputStream is;
                    try {
                        is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                            @Override
                            public InputStream run() throws IOException {
                                return url.openStream();
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (IOException)e.getException();
                    }
                    BufferedReader reader = null;
                    try {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(is));
                        int count = 0;
                        while ((line = reader.readLine()) != null) {
                            Map<String, String> attributes;
                            String className;
                            if ((line = line.trim()).startsWith("#") || "".equals(line)) continue;
                            String reg = line.trim();
                            if (debug) {
                                logger.fine("Registering service provider: " + reg);
                            }
                            if ((className = (attributes = OSGiServiceDiscoverer.parseServiceDeclaration(reg)).get("class")) == null) {
                                className = "_class_" + count;
                                ++count;
                            }
                            ServiceDeclarationImpl descriptor = new ServiceDeclarationImpl(bundle, url, className, attributes);
                            descriptors.add(descriptor);
                            if (!firstOnly) continue;
                            HashSet<ServiceDeclaration> hashSet = descriptors;
                            return hashSet;
                        }
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            ++i$;
        }
        return descriptors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceDeclarationImpl
    implements ServiceDeclaration {
        private Bundle bundle;
        private URL url;
        private String className;
        private Class<?> javaClass;
        private Map<String, String> attributes;

        public ServiceDeclarationImpl(Bundle bundle, URL url, String className, Map<String, String> attributes) {
            this.bundle = bundle;
            this.url = url;
            this.className = className;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public Class<?> loadClass() throws ClassNotFoundException {
            if (this.className == null) {
                return null;
            }
            if (this.javaClass == null) {
                this.javaClass = this.loadClass(this.className);
            }
            return this.javaClass;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            try {
                return this.bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                logger.severe(e.getMessage() + ": " + OSGiServiceDiscoverer.toString(this.bundle));
                throw e;
            }
        }

        @Override
        public URL getLocation() {
            return this.url;
        }

        @Override
        public URL getResource(final String name) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return ServiceDeclarationImpl.this.bundle.getResource(name);
                }
            });
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Bundle: ").append(OSGiServiceDiscoverer.toString(this.bundle));
            sb.append(" Resource: ").append(this.url);
            sb.append(" Attributes: ").append(this.attributes);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassLoaderImpl
    extends SecureClassLoader {
        public ClassLoaderImpl() {
            super(OSGiServiceDiscoverer.class.getClassLoader());
        }

        @Override
        protected URL findResource(String name) {
            int index = name.lastIndexOf(47);
            if (index == -1) {
                return null;
            }
            String path = name.substring(0, index);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.startsWith("META-INF/services")) {
                return null;
            }
            for (Bundle bundle : OSGiServiceDiscoverer.this.context.getBundles()) {
                URL url = bundle.getEntry(name);
                if (url == null) continue;
                return url;
            }
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            int index = name.lastIndexOf(47);
            if (index == -1) {
                return null;
            }
            String path = name.substring(0, index);
            String file = name.substring(index + 1);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.startsWith("META-INF/services")) {
                return null;
            }
            HashSet urlSet = new HashSet();
            for (Bundle bundle : OSGiServiceDiscoverer.this.context.getBundles()) {
                Enumeration urls = bundle.findEntries(path, file, false);
                if (urls == null) continue;
                urlSet.addAll(Collections.list(urls));
            }
            return Collections.enumeration(urlSet);
        }
    }
}

