/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.extension.helper.BindingActivator;
import org.apache.tuscany.sca.extension.helper.ComponentLifecycle;
import org.apache.tuscany.sca.extension.helper.InvokerFactory;
import org.apache.tuscany.sca.extension.helper.impl.BindingSCDLProcessor;
import org.apache.tuscany.sca.extension.helper.impl.DiscoveryUtils;
import org.apache.tuscany.sca.extension.helper.impl.InvokerProxy;
import org.apache.tuscany.sca.extension.helper.impl.PojoBinding;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class BindingsActivator
implements ModuleActivator {
    protected List<BindingActivator> bindingActivators;
    protected AssemblyFactory assemblyFactory;
    protected Map<Class, BindingActivator> bindingActivatorMap = new HashMap<Class, BindingActivator>();

    public void start(ExtensionPointRegistry registry) {
        ModelFactoryExtensionPoint factories = registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.assemblyFactory = factories.getFactory(AssemblyFactory.class);
        this.bindingActivators = DiscoveryUtils.discoverActivators(BindingActivator.class, registry);
        StAXArtifactProcessorExtensionPoint staxProcessors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        ProviderFactoryExtensionPoint providerFactories = registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        for (BindingActivator bindingActivator : this.bindingActivators) {
            Class<Binding> bindingClass = bindingActivator.getBindingClass();
            this.bindingActivatorMap.put(bindingClass, bindingActivator);
            QName scdlQName = this.getBindingQName(bindingClass);
            staxProcessors.addArtifactProcessor(new BindingSCDLProcessor(scdlQName, bindingClass));
            if (!Binding.class.isAssignableFrom(bindingClass)) continue;
            providerFactories.addProviderFactory(new DelegatingBindingProviderFactory(bindingClass));
        }
        providerFactories.addProviderFactory(new DelegatingBindingProviderFactory(PojoBinding.class));
    }

    public void stop(ExtensionPointRegistry registry) {
        ProviderFactory factory;
        StAXArtifactProcessorExtensionPoint staxProcessors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        ProviderFactoryExtensionPoint providerFactories = registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        for (BindingActivator bindingActivator : this.bindingActivators) {
            ProviderFactory factory2;
            StAXArtifactProcessor processor;
            if (staxProcessors != null && (processor = (StAXArtifactProcessor)staxProcessors.getProcessor(this.getBindingQName(bindingActivator.getBindingClass()))) != null) {
                staxProcessors.removeArtifactProcessor(processor);
            }
            if (providerFactories == null || bindingActivator.getBindingClass() == null || (factory2 = providerFactories.getProviderFactory(bindingActivator.getBindingClass())) == null) continue;
            providerFactories.removeProviderFactory(factory2);
        }
        if (providerFactories != null && (factory = providerFactories.getProviderFactory(PojoBinding.class)) != null) {
            providerFactories.removeProviderFactory(factory);
        }
    }

    protected QName getBindingQName(Class bindingClass) {
        String localName = bindingClass.getName();
        if (localName.lastIndexOf(46) > -1) {
            localName = localName.substring(localName.lastIndexOf(46) + 1);
        }
        if (localName.endsWith("Binding")) {
            localName = localName.substring(0, localName.length() - 7);
        }
        StringBuilder sb = new StringBuilder(localName);
        for (int i = 0; i < sb.length() && Character.isUpperCase(sb.charAt(i)); ++i) {
            sb.setCharAt(i, Character.toLowerCase(sb.charAt(i)));
        }
        return new QName("http://tuscany.apache.org/xmlns/sca/1.0", "binding." + sb.toString());
    }

    private final class DelegatingBindingProviderFactory
    implements BindingProviderFactory {
        private Class modelType;

        public DelegatingBindingProviderFactory(Class modelType) {
            this.modelType = modelType;
        }

        public ReferenceBindingProvider createReferenceBindingProvider(final RuntimeComponent rc, final RuntimeComponentReference rcr, final Binding b) {
            Object realBinding = b instanceof PojoBinding ? ((PojoBinding)b).getUserBinding() : b;
            final BindingActivator bindingActivator = BindingsActivator.this.bindingActivatorMap.get(realBinding.getClass());
            return new ReferenceBindingProvider(){
                List<InvokerProxy> invokers = new ArrayList<InvokerProxy>();
                private InvokerFactory factory;

                public Invoker createInvoker(Operation operation) {
                    InvokerProxy invoker = new InvokerProxy(this.factory, operation);
                    this.invokers.add(invoker);
                    return invoker;
                }

                public boolean supportsOneWayInvocation() {
                    return false;
                }

                public InterfaceContract getBindingInterfaceContract() {
                    return null;
                }

                public void start() {
                    this.factory = b instanceof PojoBinding ? bindingActivator.createInvokerFactory(rc, rcr, b, ((PojoBinding)b).getUserBinding()) : bindingActivator.createInvokerFactory(rc, rcr, b, b);
                    if (this.factory != null && this.factory instanceof ComponentLifecycle) {
                        ((ComponentLifecycle)((Object)this.factory)).start();
                    }
                }

                public void stop() {
                    if (this.factory instanceof ComponentLifecycle) {
                        ((ComponentLifecycle)((Object)this.factory)).stop();
                    }
                }
            };
        }

        public ServiceBindingProvider createServiceBindingProvider(final RuntimeComponent rc, final RuntimeComponentService rcs, final Binding b) {
            final Object realBinding = b instanceof PojoBinding ? ((PojoBinding)b).getUserBinding() : b;
            final BindingActivator bindingActivator = BindingsActivator.this.bindingActivatorMap.get(realBinding.getClass());
            return new ServiceBindingProvider(){
                ComponentLifecycle listener;
                {
                    this.listener = bindingActivator.createService(rc, rcs, b, realBinding);
                }

                public InterfaceContract getBindingInterfaceContract() {
                    return null;
                }

                public boolean supportsOneWayInvocation() {
                    return false;
                }

                public void start() {
                    this.listener.start();
                }

                public void stop() {
                    this.listener.stop();
                }
            };
        }

        public Class getModelType() {
            return this.modelType;
        }
    }
}

