/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.extension.helper.ImplementationActivator;
import org.apache.tuscany.sca.extension.helper.impl.DiscoveryUtils;
import org.apache.tuscany.sca.extension.helper.impl.ImplementationImplementationProvider;
import org.apache.tuscany.sca.extension.helper.impl.PojoImplementation;
import org.apache.tuscany.sca.extension.helper.impl.SCDLProcessor;
import org.apache.tuscany.sca.extension.helper.utils.DefaultPropertyValueObjectFactory;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class ImplementationsActivator
implements ModuleActivator {
    protected List<ImplementationActivator> implementationActivators;

    public void start(ExtensionPointRegistry registry) {
        ModelFactoryExtensionPoint factories = registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        AssemblyFactory assemblyFactory = factories.getFactory(AssemblyFactory.class);
        Mediator mediator = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(Mediator.class);
        DefaultPropertyValueObjectFactory propertyFactory = new DefaultPropertyValueObjectFactory(mediator);
        registry.addExtensionPoint(propertyFactory);
        this.implementationActivators = DiscoveryUtils.discoverActivators(ImplementationActivator.class, registry);
        StAXArtifactProcessorExtensionPoint staxProcessors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        ProviderFactoryExtensionPoint providerFactories = registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        for (ImplementationActivator implementationActivator : this.implementationActivators) {
            Class<Implementation> implClass = implementationActivator.getImplementationClass();
            QName scdlQName = this.getSCDLQName(implClass);
            staxProcessors.addArtifactProcessor(new SCDLProcessor(assemblyFactory, scdlQName, implClass, registry, factories));
            if (implementationActivator.getImplementationClass() == null || providerFactories == null) continue;
            this.addImplementationProvider(implementationActivator, providerFactories);
        }
    }

    public void stop(ExtensionPointRegistry registry) {
        StAXArtifactProcessorExtensionPoint staxProcessors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        for (ImplementationActivator implementationActivator : this.implementationActivators) {
            StAXArtifactProcessor processor;
            if (staxProcessors == null || (processor = (StAXArtifactProcessor)staxProcessors.getProcessor(this.getSCDLQName(implementationActivator.getImplementationClass()))) == null) continue;
            staxProcessors.removeArtifactProcessor(processor);
        }
    }

    private void addImplementationProvider(final ImplementationActivator implementationActivator, ProviderFactoryExtensionPoint providerFactories) {
        providerFactories.addProviderFactory(new ImplementationProviderFactory(){

            public ImplementationProvider createImplementationProvider(RuntimeComponent rc, Implementation impl) {
                if (impl instanceof PojoImplementation) {
                    return new ImplementationImplementationProvider(implementationActivator, rc, impl, ((PojoImplementation)impl).getUserImpl());
                }
                return new ImplementationImplementationProvider(implementationActivator, rc, impl, impl);
            }

            public Class getModelType() {
                Class c = implementationActivator.getImplementationClass();
                if (Implementation.class.isAssignableFrom(c)) {
                    return c;
                }
                return PojoImplementation.class;
            }
        });
    }

    protected QName getSCDLQName(Class implementationClass) {
        String localName = implementationClass.getName();
        if (localName.lastIndexOf(46) > -1) {
            localName = localName.substring(localName.lastIndexOf(46) + 1);
        }
        if (localName.endsWith("Implementation")) {
            localName = localName.substring(0, localName.length() - 14);
        }
        StringBuilder sb = new StringBuilder(localName);
        for (int i = 0; i < sb.length() && Character.isUpperCase(sb.charAt(i)); ++i) {
            sb.setCharAt(i, Character.toLowerCase(sb.charAt(i)));
        }
        return new QName("http://tuscany.apache.org/xmlns/sca/1.0", "implementation." + sb.toString());
    }
}

