/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.utils;

import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.ComponentPreProcessor;
import org.apache.tuscany.sca.extension.helper.utils.AbstractImplementation;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class DynamicImplementation
extends AbstractImplementation
implements ComponentPreProcessor {
    public void preProcess(Component component) {
        RuntimeComponent rtc = (RuntimeComponent)component;
        for (ComponentService service : rtc.getServices()) {
            if (this.getService(service.getName()) != null) continue;
            this.getServices().add(this.createService(service));
        }
        Service dynamicService = this.getService("$dynamic$");
        if (dynamicService != null && this.getServices().size() > 1) {
            this.getServices().remove(dynamicService);
            dynamicService = null;
        }
        for (ComponentReference reference : rtc.getReferences()) {
            if (this.getReference(reference.getName()) != null) continue;
            this.getReferences().add(this.createReference(reference));
        }
        for (ComponentProperty property : rtc.getProperties()) {
            if (this.getProptery(property.getName()) != null) continue;
            this.getProperties().add(this.createProperty(property));
        }
    }

    protected Service createService(Service service) {
        Service newService;
        try {
            newService = (Service)service.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newService;
    }

    protected Reference createReference(Reference reference) {
        Reference newReference;
        try {
            newReference = (Reference)reference.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newReference;
    }

    protected Property createProperty(Property property) {
        Property newProperty;
        try {
            newProperty = (Property)property.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newProperty;
    }
}

