/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.corba;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SocketUtil {
    protected static final Object lock = new Object();
    private static Set<String> localHostCache;
    private static Set<String> notLocalHostCache;
    private static Map<String, CacheThread> threadMap;
    private static Set<InetAddress> addressCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalhost(String host) {
        boolean refreshedCache;
        boolean currentThread;
        block34: {
            if (host == null || host.equals("")) {
                return false;
            }
            if ("localhost".equals(host) || "127.0.0.1".equals(host)) {
                return true;
            }
            try {
                InetAddress localHostaddr = InetAddress.getLocalHost();
                if (localHostaddr.getHostName().equals(host) || host.equals(localHostaddr.getCanonicalHostName()) || localHostaddr.getHostAddress().equals(host)) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            currentThread = false;
            try {
                Thread t = null;
                Object object = lock;
                synchronized (object) {
                    t = threadMap.get(host);
                }
                if (t != null && t.isAlive()) {
                    currentThread = true;
                    t.join(30L);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            refreshedCache = false;
            try {
                HashSet<InetAddress> currentAddresses = new HashSet<InetAddress>();
                currentAddresses.add(InetAddress.getLocalHost());
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface inter = nis.nextElement();
                    Enumeration<InetAddress> ias = inter.getInetAddresses();
                    while (ias.hasMoreElements()) {
                        currentAddresses.add(ias.nextElement());
                    }
                }
                if (addressCache != null && addressCache.containsAll(currentAddresses) && currentAddresses.containsAll(addressCache)) break block34;
                CacheThread cacheThread = null;
                refreshedCache = true;
                Object object = lock;
                synchronized (object) {
                    addressCache = currentAddresses;
                    notLocalHostCache = new HashSet<String>();
                    localHostCache = new HashSet<String>(currentAddresses.size() * 3);
                    for (InetAddress addr : currentAddresses) {
                        String a = addr.getHostAddress();
                        if (a == null || localHostCache.contains(a)) continue;
                        localHostCache.add(a);
                    }
                    cacheThread = new CacheThread(host, currentAddresses, localHostCache, notLocalHostCache, threadMap);
                    threadMap.put(host, cacheThread);
                    cacheThread.setDaemon(true);
                    cacheThread.setPriority(4);
                    cacheThread.start();
                }
                cacheThread.join(200L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object e = lock;
        synchronized (e) {
            if (localHostCache.contains(host)) {
                return true;
            }
            if (notLocalHostCache.contains(host)) {
                return false;
            }
        }
        if (!refreshedCache && !currentThread) {
            try {
                CacheThread cacheThread = null;
                Object object = lock;
                synchronized (object) {
                    cacheThread = new CacheThread(host, null, localHostCache, notLocalHostCache, threadMap);
                    threadMap.put(host, cacheThread);
                    cacheThread.setDaemon(true);
                    cacheThread.setPriority(4);
                    cacheThread.start();
                }
                cacheThread.join(75L);
                object = lock;
                synchronized (object) {
                    if (localHostCache.contains(host)) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        notLocalHostCache = new HashSet<String>();
        threadMap = new HashMap<String, CacheThread>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheThread
    extends Thread {
        private Set<InetAddress> currentAddresses;
        private Set<String> addressList;
        private String host;
        private Set<String> nonAddressList;
        private Map<String, CacheThread> threadMap2;

        public CacheThread(String host, Set<InetAddress> currentAddresses, Set<String> addressList, Set<String> nonAddressList, Map<String, CacheThread> threadMap2) {
            super("Caching localhost information");
            this.host = host;
            this.currentAddresses = currentAddresses;
            this.addressList = addressList;
            this.nonAddressList = nonAddressList;
            this.threadMap2 = threadMap2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.currentAddresses != null) {
                for (InetAddress addr : this.currentAddresses) {
                    String hostname = addr.getHostName();
                    String hostname2 = addr.getCanonicalHostName();
                    Object object = lock;
                    synchronized (object) {
                        if (hostname != null && !this.addressList.contains(hostname)) {
                            this.addressList.add(hostname);
                        }
                        if (hostname2 != null && !this.addressList.contains(hostname2)) {
                            this.addressList.add(hostname2);
                        }
                    }
                }
            }
            try {
                InetAddress[] addrs = InetAddress.getAllByName(this.host);
                int length = addrs.length;
                for (int j = 0; j < length; ++j) {
                    InetAddress addr = addrs[0];
                    String hostname = addr.getHostName();
                    String hostname2 = addr.getCanonicalHostName();
                    Object object = lock;
                    synchronized (object) {
                        if (addr.isLoopbackAddress()) {
                            if (hostname != null && !this.addressList.contains(hostname)) {
                                this.addressList.add(hostname);
                            }
                            if (hostname2 != null && !this.addressList.contains(hostname2)) {
                                this.addressList.add(hostname2);
                            }
                        } else {
                            if (hostname != null && !this.nonAddressList.contains(hostname)) {
                                this.nonAddressList.add(hostname);
                            }
                            if (hostname2 != null && !this.nonAddressList.contains(hostname2)) {
                                this.nonAddressList.add(hostname2);
                            }
                        }
                        continue;
                    }
                }
            }
            catch (UnknownHostException e) {
                Object object = lock;
                synchronized (object) {
                    if (this.host != null && !this.nonAddressList.contains(this.host)) {
                        this.nonAddressList.add(this.host);
                    }
                }
            }
            Object object = lock;
            synchronized (object) {
                this.threadMap2.remove(this.host);
            }
        }
    }
}

