/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.corba.jse.tns;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.tuscany.sca.host.corba.CorbaHost;
import org.apache.tuscany.sca.host.corba.CorbaHostException;
import org.apache.tuscany.sca.host.corba.CorbanameURL;
import org.apache.tuscany.sca.host.corba.SocketUtil;
import org.apache.tuscany.sca.host.corba.jse.DefaultCorbaHost;
import org.apache.tuscany.sca.host.corba.naming.TransientNameServer;
import org.omg.CORBA.Object;

public class TnsDefaultCorbaHost
implements CorbaHost {
    private static final Logger logger = Logger.getLogger(TnsDefaultCorbaHost.class.getName());
    private Map<Integer, TransientNameServer> localServers = new ConcurrentHashMap<Integer, TransientNameServer>();
    private Map<Integer, Integer> clientsCount = new ConcurrentHashMap<Integer, Integer>();
    private CorbaHost targetHost = new DefaultCorbaHost();

    public void registerServant(String uri, Object servantObject) throws CorbaHostException {
        CorbanameURL details = new CorbanameURL(uri);
        if (SocketUtil.isLocalhost(details.getHost())) {
            this.createLocalNameServer(details.getPort());
        }
        this.targetHost.registerServant(uri, servantObject);
    }

    public void unregisterServant(String uri) throws CorbaHostException {
        this.targetHost.unregisterServant(uri);
        CorbanameURL details = new CorbanameURL(uri);
        if (SocketUtil.isLocalhost(details.getHost())) {
            this.releaseLocalNameServer(details.getPort());
        }
    }

    public Object lookup(String uri) throws CorbaHostException {
        return this.targetHost.lookup(uri);
    }

    private synchronized void createLocalNameServer(int port) throws CorbaHostException {
        int useCount;
        int n = useCount = this.clientsCount.containsKey(port) ? this.clientsCount.get(port) : 0;
        if (useCount == 0) {
            TransientNameServer server = new TransientNameServer("localhost", port, "TNameService");
            Thread thread = server.start();
            if (thread == null) {
                throw new CorbaHostException("TransientNameServer couldn't be started");
            }
            this.localServers.put(port, server);
        }
        this.clientsCount.put(port, ++useCount);
    }

    private synchronized void releaseLocalNameServer(int port) throws CorbaHostException {
        int useCount;
        int n = useCount = this.clientsCount.containsKey(port) ? this.clientsCount.get(port) : 0;
        if (useCount == 1) {
            TransientNameServer server = this.localServers.get(port);
            if (server != null) {
                server.stop();
                this.clientsCount.remove(port);
                this.localServers.remove(port);
            } else {
                logger.warning("Local name server on port " + port + " was null!");
            }
        } else if (useCount > 1) {
            this.clientsCount.put(port, --useCount);
        } else {
            logger.warning("Tried to release non existing local name server on port " + port);
        }
    }

    public void stop() {
        for (TransientNameServer tns : this.localServers.values()) {
            tns.stop();
        }
    }
}

