/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded.impl;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionService;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.context.ServiceReferenceImpl;
import org.apache.tuscany.sca.host.embedded.SCADomain;
import org.apache.tuscany.sca.host.embedded.impl.ComponentManagerImpl;
import org.apache.tuscany.sca.host.embedded.management.ComponentManager;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.node.impl.RuntimeBootStrapper;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentContext;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.osoa.sca.CallableReference;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedSCADomain
extends SCADomain {
    private String uri;
    private Composite domainComposite;
    private RuntimeBootStrapper runtime;
    private ComponentManagerImpl componentManager = new ComponentManagerImpl(this);

    public EmbeddedSCADomain(ClassLoader runtimeClassLoader, String domainURI) {
        this.uri = domainURI;
        this.runtime = new RuntimeBootStrapper(runtimeClassLoader);
    }

    public void start() throws ActivationException {
        this.runtime.start();
        AssemblyFactory assemblyFactory = this.runtime.getAssemblyFactory();
        this.domainComposite = assemblyFactory.createComposite();
        this.domainComposite.setName(new QName("http://www.osoa.org/xmlns/sca/1.0", "domain"));
        this.domainComposite.setURI(this.uri);
        this.getCompositeActivator().setDomainComposite(this.domainComposite);
    }

    public void stop() throws ActivationException {
        this.runtime.stop();
        this.domainComposite = null;
    }

    public void buildComposite(Composite composite) throws CompositeBuilderException {
        this.runtime.buildComposite(composite);
    }

    public ContributionService getContributionService() {
        return this.runtime.getContributionService();
    }

    public CompositeBuilder getCompositeBuilder() {
        return this.runtime.getCompositeBuilder();
    }

    public CompositeActivator getCompositeActivator() {
        return this.runtime.getCompositeActivator();
    }

    public Composite getDomainComposite() {
        return this.domainComposite;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        return this.runtime.getProxyFactory().cast(target);
    }

    @Override
    public <B> B getService(Class<B> businessInterface, String serviceName) {
        ServiceReference<B> serviceReference = this.getServiceReference(businessInterface, serviceName);
        if (serviceReference == null) {
            throw new ServiceRuntimeException("Service not found: " + serviceName);
        }
        return serviceReference.getService();
    }

    private <B> ServiceReference<B> createServiceReference(Class<B> businessInterface, String targetURI) {
        try {
            AssemblyFactory assemblyFactory = this.runtime.getAssemblyFactory();
            Composite composite = assemblyFactory.createComposite();
            composite.setName(new QName("http://tuscany.apache.org/xmlns/sca/1.0", "default"));
            RuntimeComponent component = (RuntimeComponent)assemblyFactory.createComponent();
            component.setName("default");
            component.setURI("default");
            this.runtime.getCompositeActivator().configureComponentContext(component);
            composite.getComponents().add(component);
            RuntimeComponentReference reference = (RuntimeComponentReference)assemblyFactory.createComponentReference();
            reference.setName("default");
            ModelFactoryExtensionPoint factories = this.runtime.getExtensionPointRegistry().getExtensionPoint(ModelFactoryExtensionPoint.class);
            JavaInterfaceFactory javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
            JavaInterfaceContract interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
            interfaceContract.setInterface(javaInterfaceFactory.createJavaInterface(businessInterface));
            reference.setInterfaceContract(interfaceContract);
            component.getReferences().add(reference);
            reference.setComponent(component);
            SCABindingFactory scaBindingFactory = factories.getFactory(SCABindingFactory.class);
            SCABinding binding = scaBindingFactory.createSCABinding();
            binding.setURI(targetURI);
            reference.getBindings().add(binding);
            return new ServiceReferenceImpl<B>(businessInterface, component, reference, binding, this.runtime.getProxyFactory(), this.runtime.getCompositeActivator());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String name) {
        String serviceName;
        String componentName;
        int i = name.indexOf(47);
        if (i != -1) {
            componentName = name.substring(0, i);
            serviceName = name.substring(i + 1);
        } else {
            componentName = name;
            serviceName = null;
        }
        Component component = this.componentManager.getComponent(componentName);
        if (component == null) {
            return this.createServiceReference(businessInterface, name);
        }
        RuntimeComponentContext componentContext = null;
        if (component.getImplementation() instanceof Composite) {
            for (ComponentService componentService : component.getServices()) {
                if (serviceName != null && !serviceName.equals(componentService.getName())) continue;
                CompositeService compositeService = (CompositeService)componentService.getService();
                if (compositeService == null) break;
                if (serviceName != null) {
                    serviceName = "$promoted$" + component.getName() + "$slash$" + serviceName;
                }
                componentContext = ((RuntimeComponent)compositeService.getPromotedComponent()).getComponentContext();
                return componentContext.createSelfReference(businessInterface, compositeService.getPromotedService());
            }
            throw new ServiceRuntimeException("Composite service not found: " + name);
        }
        componentContext = ((RuntimeComponent)component).getComponentContext();
        if (serviceName != null) {
            return componentContext.createSelfReference(businessInterface, serviceName);
        }
        return componentContext.createSelfReference(businessInterface);
    }

    @Override
    public String getURI() {
        return this.uri;
    }
}

