/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.jms.asf;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.host.jms.JMSServiceListener;
import org.apache.tuscany.sca.work.WorkScheduler;

public class ASFListener
implements JMSServiceListener {
    private static final Logger logger = Logger.getLogger(ASFListener.class.getName());
    private MessageListener listener;
    private String serviceName;
    private boolean isCallbackService;
    private JMSBinding jmsBinding;
    private WorkScheduler workScheduler;
    private JMSResourceFactory jmsResourceFactory;
    private MessageConsumer consumer;
    private boolean running;
    private Destination destination;

    public ASFListener(MessageListener listener, String serviceName, boolean isCallbackService, JMSBinding jmsBinding, WorkScheduler workScheduler, JMSResourceFactory rf) {
        this.listener = listener;
        this.serviceName = serviceName;
        this.isCallbackService = isCallbackService;
        this.jmsBinding = jmsBinding;
        this.workScheduler = workScheduler;
        this.jmsResourceFactory = rf;
    }

    public void start() {
        this.running = true;
        try {
            this.registerListerner();
        }
        catch (Exception e) {
            throw new JMSBindingException("Error starting JMSServiceBinding", e);
        }
    }

    public void stop() {
        block2: {
            this.running = false;
            try {
                this.consumer.close();
                this.jmsResourceFactory.closeConnection();
                this.jmsResourceFactory.closeResponseConnection();
            }
            catch (Exception e) {
                if ("Transport disposed.".equals(e.getMessage())) break block2;
                throw new JMSBindingException("Error stopping JMSServiceBinding", e);
            }
        }
    }

    private void registerListerner() throws NamingException, JMSException {
        Session session = this.jmsResourceFactory.createSession();
        this.destination = this.lookupDestinationQueue();
        if (this.destination == null) {
            this.destination = session.createTemporaryQueue();
        }
        this.consumer = this.jmsBinding.getJMSSelector() != null ? session.createConsumer(this.destination, this.jmsBinding.getJMSSelector()) : session.createConsumer(this.destination);
        try {
            this.consumer.setMessageListener(this.listener);
            this.jmsResourceFactory.startConnection();
        }
        catch (JMSException e) {
            this.jmsResourceFactory.startConnection();
            this.workScheduler.scheduleWork(new Runnable(){

                public void run() {
                    try {
                        while (ASFListener.this.running) {
                            final Message msg = ASFListener.this.consumer.receive();
                            ASFListener.this.workScheduler.scheduleWork(new Runnable(){

                                public void run() {
                                    try {
                                        ASFListener.this.listener.onMessage(msg);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        logger.log(Level.INFO, "JMS " + (this.isCallbackService ? "callback service" : "service") + " '" + this.serviceName + "' listening on destination " + (this.destination instanceof Queue ? ((Queue)this.destination).getQueueName() : ((Topic)this.destination).getTopicName()));
    }

    private Destination lookupDestinationQueue() throws NamingException, JMSBindingException {
        if (this.isCallbackService && this.jmsBinding.getDestinationName() == null) {
            return null;
        }
        Destination destination = this.jmsResourceFactory.lookupDestination(this.jmsBinding.getDestinationName());
        String qCreateMode = this.jmsBinding.getDestinationCreate();
        if (qCreateMode.equals("always")) {
            if (destination != null) {
                throw new JMSBindingException("JMS Destination " + this.jmsBinding.getDestinationName() + " already exists but has create mode of \"" + qCreateMode + "\" while registering service " + this.serviceName + " listener");
            }
            destination = this.jmsResourceFactory.createDestination(this.jmsBinding.getDestinationName());
        } else if (qCreateMode.equals("ifnotexist")) {
            if (destination == null) {
                destination = this.jmsResourceFactory.createDestination(this.jmsBinding.getDestinationName());
            }
        } else if (qCreateMode.equals("never") && destination == null) {
            throw new JMSBindingException("JMS Destination " + this.jmsBinding.getDestinationName() + " not found but create mode of \"" + qCreateMode + "\" while registering service " + this.serviceName + " listener");
        }
        if (destination == null) {
            throw new JMSBindingException("JMS Destination " + this.jmsBinding.getDestinationName() + " not found with create mode of \"" + qCreateMode + "\" while registering service " + this.serviceName + " listener");
        }
        return destination;
    }

    public String getDestinationName() {
        try {
            if (this.destination instanceof Queue) {
                return ((Queue)this.destination).getQueueName();
            }
            if (this.destination instanceof Topic) {
                return ((Topic)this.destination).getTopicName();
            }
            return null;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }
}

