/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.jms.asf;

import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.host.jms.JMSServiceListener;
import org.apache.tuscany.sca.host.jms.JMSServiceListenerDetails;
import org.apache.tuscany.sca.host.jms.JMSServiceListenerFactory;
import org.apache.tuscany.sca.host.jms.asf.ASFListener;
import org.apache.tuscany.sca.host.jms.asf.ServiceInvoker;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.work.WorkScheduler;

public class JMSServiceListenerFactoryImpl
implements JMSServiceListenerFactory {
    private WorkScheduler workScheduler;

    public JMSServiceListenerFactoryImpl(WorkScheduler workScheduler) {
        this.workScheduler = workScheduler;
    }

    public JMSServiceListener createJMSServiceListener(JMSServiceListenerDetails jmsSLD) {
        try {
            JMSResourceFactory rf = ((JMSBindingServiceBindingProvider)jmsSLD).getResourceFactory();
            ServiceInvoker listener = new ServiceInvoker(jmsSLD.getJmsBinding(), jmsSLD.getService(), jmsSLD.getTargetBinding(), jmsSLD.getMessageFactory(), rf);
            RuntimeComponentService service = jmsSLD.getService();
            return new ASFListener(listener, service.getName(), service.isCallback(), jmsSLD.getJmsBinding(), this.workScheduler, rf);
        }
        catch (NamingException e) {
            throw new JMSBindingException(e);
        }
    }
}

