/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.jms.asf;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class ServiceInvoker
implements MessageListener {
    private static final Logger logger = Logger.getLogger(ServiceInvoker.class.getName());
    private JMSBinding jmsBinding;
    private Binding targetBinding;
    private JMSResourceFactory jmsResourceFactory;
    private RuntimeComponentService service;
    private MessageFactory messageFactory;

    public ServiceInvoker(JMSBinding jmsBinding, RuntimeComponentService service, Binding targetBinding, MessageFactory messageFactory, JMSResourceFactory rf) throws NamingException {
        this.jmsBinding = jmsBinding;
        this.jmsResourceFactory = rf;
        this.service = service;
        this.targetBinding = targetBinding;
        this.messageFactory = messageFactory;
    }

    public void onMessage(javax.jms.Message requestJMSMsg) {
        logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' received message " + requestJMSMsg);
        try {
            this.invokeService(requestJMSMsg);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception send fault response '" + this.service.getName(), e);
        }
    }

    protected void invokeService(javax.jms.Message requestJMSMsg) throws JMSException, InvocationTargetException {
        Message tuscanyMsg = this.messageFactory.createMessage();
        JMSBindingContext context = new JMSBindingContext();
        tuscanyMsg.setBindingContext(context);
        context.setJmsMsg(requestJMSMsg);
        context.setJmsResourceFactory(this.jmsResourceFactory);
        context.setReplyToDestination(requestJMSMsg.getJMSReplyTo());
        tuscanyMsg.setBody(requestJMSMsg);
        this.service.getRuntimeWire(this.targetBinding).invoke(tuscanyMsg);
    }
}

