/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.rmi;

import java.rmi.Remote;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.host.rmi.RMIHostException;
import org.apache.tuscany.sca.host.rmi.RMIHostExtensionPoint;
import org.apache.tuscany.sca.host.rmi.RMIHostRuntimeException;

public class ExtensibleRMIHost
implements RMIHost {
    private RMIHostExtensionPoint rmiHosts;

    public ExtensibleRMIHost(RMIHostExtensionPoint rmiHosts) {
        this.rmiHosts = rmiHosts;
    }

    public void registerService(String serviceName, int port, Remote serviceObject) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host available");
        }
        this.rmiHosts.getRMIHosts().get(0).registerService(serviceName, port, serviceObject);
    }

    public Remote findService(String host, String port, String svcName) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host available");
        }
        return this.rmiHosts.getRMIHosts().get(0).findService(host, port, svcName);
    }

    public void registerService(String serviceName, Remote serviceObject) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host available");
        }
        this.rmiHosts.getRMIHosts().get(0).registerService(serviceName, serviceObject);
    }

    public void unregisterService(String serviceName) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host available");
        }
        this.rmiHosts.getRMIHosts().get(0).unregisterService(serviceName);
    }

    public void unregisterService(String serviceName, int port) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host available");
        }
        this.rmiHosts.getRMIHosts().get(0).unregisterService(serviceName, port);
    }
}

