/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.webapp.WebAppServletHost;
import org.apache.tuscany.sca.host.webapp.WebSCADomain;

public class WebAppModuleActivator
implements ModuleActivator {
    public void start(ExtensionPointRegistry extensionPointRegistry) {
        ServletHostExtensionPoint servletHosts = extensionPointRegistry.getExtensionPoint(ServletHostExtensionPoint.class);
        List<ServletHost> hosts = servletHosts.getServletHosts();
        if (this.isRunningInWebapp()) {
            if (hosts.size() > 0) {
                hosts.removeAll(hosts);
            }
            servletHosts.addServletHost(WebAppServletHost.getInstance());
        }
    }

    public void stop(ExtensionPointRegistry registry) {
        ServletHostExtensionPoint servletHosts = registry.getExtensionPoint(ServletHostExtensionPoint.class);
        List<ServletHost> hosts = servletHosts.getServletHosts();
        hosts.clear();
    }

    private boolean isRunningInWebapp() {
        for (StackTraceElement ste : new Exception().getStackTrace()) {
            if (!ste.getClassName().equals(WebSCADomain.class.getName())) continue;
            return true;
        }
        return false;
    }
}

