/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.beans.Introspector;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.LogFactory;
import org.apache.tuscany.sca.host.embedded.SCADomain;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletMappingException;
import org.apache.tuscany.sca.host.webapp.WebAppRequestDispatcher;
import org.apache.tuscany.sca.host.webapp.WebSCADomain;

public class WebAppServletHost
implements ServletHost {
    private static final Logger logger = Logger.getLogger(WebAppServletHost.class.getName());
    public static final String SCA_DOMAIN_ATTRIBUTE = "org.apache.tuscany.sca.SCADomain";
    private static WebAppServletHost instance = null;
    private Map<String, Servlet> servlets = new HashMap<String, Servlet>();
    private SCADomain scaDomain;
    private String contextPath = "/";
    private int defaultPortNumber = 8080;
    private String contributionRoot;
    private ServletContext servletContext;

    private WebAppServletHost() {
    }

    public void setDefaultPort(int port) {
        this.defaultPortNumber = port;
    }

    public int getDefaultPort() {
        return this.defaultPortNumber;
    }

    public void addServletMapping(String suri, Servlet servlet) throws ServletMappingException {
        this.addServletMapping(suri, servlet, null);
    }

    public void addServletMapping(String suri, Servlet servlet, SecurityContext securityContext) throws ServletMappingException {
        URI pathURI = URI.create(suri);
        if (!(suri = pathURI.getPath()).startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        this.servlets.put(suri, servlet);
        logger.info("Added Servlet mapping: " + suri);
    }

    public Servlet removeServletMapping(String suri) throws ServletMappingException {
        URI pathURI = URI.create(suri);
        if (!(suri = pathURI.getPath()).startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        return this.servlets.remove(suri);
    }

    public Servlet getServletMapping(String suri) throws ServletMappingException {
        URI pathURI = URI.create(suri);
        if (!(suri = pathURI.getPath()).startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        Servlet servlet = this.servlets.get(suri);
        return servlet;
    }

    public URL getURLMapping(String suri) throws ServletMappingException {
        URL url;
        String host;
        int portNumber;
        URI uri = URI.create(suri);
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((portNumber = uri.getPort()) == -1) {
            portNumber = this.defaultPortNumber;
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (this.contextPath != null && !path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        try {
            url = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException(e);
        }
        return url;
    }

    public RequestDispatcher getRequestDispatcher(String suri) throws ServletMappingException {
        Servlet servlet;
        if (!suri.startsWith("/")) {
            suri = '/' + suri;
        }
        if ((servlet = this.servlets.get(suri = this.contextPath + suri)) != null) {
            return new WebAppRequestDispatcher(suri, servlet);
        }
        for (Map.Entry<String, Servlet> entry : this.servlets.entrySet()) {
            String servletPath = entry.getKey();
            if (!servletPath.endsWith("*")) continue;
            if (suri.startsWith(servletPath = servletPath.substring(0, servletPath.length() - 1))) {
                return new WebAppRequestDispatcher(entry.getKey().substring(this.contextPath.length()), entry.getValue());
            }
            if (!(suri + "/").startsWith(servletPath)) continue;
            return new WebAppRequestDispatcher(entry.getKey().substring(this.contextPath.length()), entry.getValue());
        }
        return null;
    }

    public static WebAppServletHost getInstance() {
        if (instance == null) {
            instance = new WebAppServletHost();
        }
        return instance;
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        if (this.servletContext.getAttribute(SCA_DOMAIN_ATTRIBUTE) == null) {
            this.initContextPath(config);
            String domainURI = "http://localhost/" + this.contextPath;
            this.contributionRoot = this.getContributionRoot(this.servletContext);
            System.setProperty(SCADomain.class.getName(), WebSCADomain.class.getName());
            this.scaDomain = SCADomain.newInstance(domainURI, this.contributionRoot, new String[0]);
            this.servletContext.setAttribute(SCA_DOMAIN_ATTRIBUTE, (Object)this.scaDomain);
        }
        for (Servlet servlet : this.servlets.values()) {
            servlet.init(config);
        }
    }

    protected String getContributionRoot(ServletContext servletContext) {
        String contributionRoot = null;
        try {
            InitialContext ic = new InitialContext();
            URL repoURL = (URL)ic.lookup("java:comp/env/url/contributions");
            contributionRoot = repoURL.toString();
        }
        catch (NamingException e) {
            try {
                URL rootURL;
                String root = servletContext.getInitParameter("contributionRoot");
                if (root == null || root.length() < 1) {
                    root = "/";
                }
                if ((rootURL = servletContext.getResource(root)).getProtocol().equals("jndi")) {
                    File warRootFile = new File(servletContext.getRealPath(root));
                    contributionRoot = warRootFile.toURL().toString();
                } else {
                    contributionRoot = rootURL.toString();
                }
            }
            catch (MalformedURLException mf) {
                // empty catch block
            }
        }
        return contributionRoot;
    }

    public void initContextPath(ServletConfig config) {
        if (Collections.list(config.getInitParameterNames()).contains("contextPath")) {
            this.contextPath = config.getInitParameter("contextPath");
        } else {
            ServletContext context = config.getServletContext();
            try {
                Method m = context.getClass().getMethod("getContextPath", new Class[0]);
                this.contextPath = (String)m.invoke((Object)context, new Object[0]);
            }
            catch (Exception e) {
                logger.warning("Servlet level is: " + context.getMajorVersion() + "." + context.getMinorVersion());
                throw new IllegalStateException("'contextPath' init parameter must be set for pre-2.5 servlet container");
            }
        }
        logger.info("ContextPath: " + this.contextPath);
    }

    void destroy() {
        for (Servlet servlet : this.servlets.values()) {
            servlet.destroy();
        }
        if (this.scaDomain != null) {
            this.scaDomain.close();
            if (this.scaDomain instanceof WebSCADomain) {
                ((WebSCADomain)this.scaDomain).destroy();
            }
            this.servletContext.setAttribute(SCA_DOMAIN_ATTRIBUTE, null);
            this.scaDomain = null;
        }
        this.servletContext = null;
        instance = null;
        this.servlets.clear();
        LogFactory.release((ClassLoader)this.getClass().getClassLoader());
        Introspector.flushCaches();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String path) {
    }

    public void setContextPath2(String path) {
        if (path != null && path.length() > 0) {
            this.contextPath = path;
        }
    }

    public String getContributionRoot() {
        return this.contributionRoot;
    }

    public void setAttribute(String name, Object value) {
        this.servletContext.setAttribute(name, value);
    }
}

