/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp.jsp;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.tuscany.sca.host.embedded.SCADomain;
import org.apache.tuscany.sca.host.webapp.WebAppServletHost;
import org.osoa.sca.ComponentContext;

public class ReferenceTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String type;
    protected Integer scope = 1;

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        Object o;
        Class<?> typeClass;
        try {
            WebAppServletHost.getInstance().init(this.pageContext.getServletConfig());
        }
        catch (ServletException e) {
            throw new JspException("Exception initializing Tuscany webapp: " + (Object)((Object)e), (Throwable)e);
        }
        ServletContext servletContext = this.pageContext.getServletContext();
        ComponentContext componentContext = (ComponentContext)servletContext.getAttribute("org.osoa.sca.ComponentContext");
        SCADomain scaDomain = null;
        if (componentContext == null && (scaDomain = (SCADomain)servletContext.getAttribute("org.apache.tuscany.sca.SCADomain")) == null) {
            throw new JspException("SCADomain is null. Check Tuscany configuration in web.xml");
        }
        try {
            typeClass = Class.forName(this.type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new JspException("Reference '" + this.name + "' type class not found: " + this.type);
        }
        try {
            o = componentContext != null ? componentContext.getService(typeClass, this.name) : scaDomain.getService(typeClass, this.name);
        }
        catch (Exception e) {
            throw new JspException("Exception getting service for reference'" + this.name + "': " + e, (Throwable)e);
        }
        if (o == null) {
            throw new JspException("Reference '" + this.name + "' not found");
        }
        this.pageContext.setAttribute(this.name, o, this.scope.intValue());
        return 6;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getScope() {
        return this.scope;
    }

    public void setScope(Integer scope) {
        this.scope = scope;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

