/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.jetty;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.resource.Resource;
import org.mortbay.resource.URLResource;

public class JettyDefaultServlet
extends DefaultServlet {
    private static final long serialVersionUID = 7000218247190209353L;
    private String documentRoot;
    private String servletPath;

    public JettyDefaultServlet(String servletPath, String documentRoot) {
        this.servletPath = servletPath + '/';
        this.documentRoot = documentRoot;
    }

    public Resource getResource(String pathInContext) {
        if (pathInContext.startsWith(this.servletPath)) {
            pathInContext = pathInContext.length() > this.servletPath.length() ? pathInContext.substring(this.servletPath.length()) : "";
        } else if ((pathInContext + "/").equals(this.servletPath)) {
            pathInContext = "";
        }
        try {
            URL url = new URL(this.documentRoot + "/" + pathInContext);
            return new URLResource(url, url.openConnection()){
                private static final long serialVersionUID = 8560952113883507717L;

                public File getFile() throws IOException {
                    return null;
                }
            };
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getInitParameter(String name) {
        if ("resourceBase".equals(name)) {
            return this.documentRoot;
        }
        if ("redirectWelcome".equals(name)) {
            return "true";
        }
        return super.getInitParameter(name);
    }
}

