/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.jetty;

import org.mortbay.log.Logger;

public class JettyLogger
implements Logger {
    private boolean debugEnabled;

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void info(String msg, Object arg0, Object arg1) {
        if (this.debugEnabled) {
            System.err.println(":INFO:  " + this.format(msg, arg0, arg1));
        }
    }

    public void debug(String msg, Throwable th) {
        if (this.debugEnabled) {
            System.err.println(":DEBUG:  " + msg);
            th.printStackTrace();
        }
    }

    public void debug(String msg, Object arg0, Object arg1) {
        if (this.debugEnabled) {
            System.err.println(":DEBUG: " + this.format(msg, arg0, arg1));
        }
    }

    public void warn(String msg, Object arg0, Object arg1) {
        if (this.debugEnabled) {
            System.err.println(":WARN: " + this.format(msg, arg0, arg1));
        }
    }

    public void warn(String msg, Throwable th) {
        if (this.debugEnabled) {
            System.err.println(":WARN: " + msg);
            th.printStackTrace();
        }
    }

    public Logger getLogger(String name) {
        return this;
    }

    private String format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
        }
        if (arg0 != null && i0 >= 0) {
            msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
        }
        return msg;
    }
}

