/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.ode;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.CountLRUDehydrationPolicy;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.JdbcDelegate;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.utils.GUID;
import org.apache.tuscany.sca.implementation.bpel.BPELImplementation;
import org.apache.tuscany.sca.implementation.bpel.ode.GeronimoTxFactory;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEBindingContext;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEDeployment;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEDeploymentException;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEInitializationException;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEMessageExchangeContext;
import org.apache.tuscany.sca.implementation.bpel.ode.ODEShutdownException;
import org.apache.tuscany.sca.implementation.bpel.ode.TuscanyProcessConfImpl;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class EmbeddedODEServer {
    protected final Log __log = LogFactory.getLog(this.getClass());
    private boolean _initialized;
    private OdeConfigProperties _config;
    private TransactionManager _txMgr;
    private Database _db;
    private File _workRoot;
    private BpelDAOConnectionFactoryJDBC _daoCF;
    private BpelServerImpl _bpelServer;
    private Scheduler _scheduler;
    protected ExecutorService _executorService;
    private Map<QName, RuntimeComponent> tuscanyRuntimeComponents = new ConcurrentHashMap<QName, RuntimeComponent>();

    public EmbeddedODEServer(TransactionManager txMgr) {
        this._txMgr = txMgr;
    }

    public void init() throws ODEInitializationException {
        Properties p = System.getProperties();
        p.put("derby.system.home", "target");
        Properties confProps = new Properties();
        confProps.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=false)");
        this._config = new OdeConfigProperties(confProps, "ode-sca");
        URL dbLocation = this.getClass().getClassLoader().getResource("jpadb");
        if (dbLocation == null) {
            throw new ODEInitializationException("Couldn't find database in the classpath");
        }
        this._workRoot = new File(dbLocation.getFile()).getParentFile();
        this.initTxMgr();
        this.initPersistence();
        this.initBpelServer();
        try {
            this._bpelServer.start();
        }
        catch (Exception ex) {
            String errmsg = "An error occured during the ODE BPEL server startup.";
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ODEInitializationException(errmsg, ex);
        }
        this.__log.info((Object)"ODE BPEL server started.");
        this._initialized = true;
    }

    private void initTxMgr() {
        if (this._txMgr == null) {
            try {
                GeronimoTxFactory txFactory = new GeronimoTxFactory();
                this._txMgr = txFactory.getTransactionManager();
            }
            catch (Exception e) {
                this.__log.fatal((Object)"Couldn't initialize a transaction manager using Geronimo's transaction factory.", (Throwable)e);
                throw new ODEInitializationException("Couldn't initialize a transaction manager using Geronimo's transaction factory.", e);
            }
        }
    }

    private void initPersistence() {
        this._db = new Database(this._config);
        this._db.setTransactionManager(this._txMgr);
        this._db.setWorkRoot(this._workRoot);
        try {
            this._db.start();
            this._daoCF = this._db.createDaoCF();
        }
        catch (Exception ex) {
            String errmsg = "Error while configuring ODE persistence.";
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ODEInitializationException(errmsg, ex);
        }
    }

    private void initBpelServer() {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)"ODE initializing");
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            int threadNumber = 0;

            public Thread newThread(Runnable r) {
                ++this.threadNumber;
                Thread t = new Thread(r, "EmbeddedODEServer-" + this.threadNumber);
                t.setDaemon(true);
                return t;
            }
        };
        this._executorService = Executors.newCachedThreadPool(threadFactory);
        this._bpelServer = new BpelServerImpl();
        this._scheduler = this.createScheduler();
        this._scheduler.setJobProcessor((Scheduler.JobProcessor)this._bpelServer);
        this._bpelServer.setDaoConnectionFactory((BpelDAOConnectionFactory)this._daoCF);
        this._bpelServer.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl(this._scheduler));
        this._bpelServer.setMessageExchangeContext((MessageExchangeContext)new ODEMessageExchangeContext(this));
        this._bpelServer.setBindingContext((BindingContext)new ODEBindingContext());
        this._bpelServer.setScheduler(this._scheduler);
        if (this._config.isDehydrationEnabled()) {
            CountLRUDehydrationPolicy dehy = new CountLRUDehydrationPolicy();
            this._bpelServer.setDehydrationPolicy((DehydrationPolicy)dehy);
        }
        this._bpelServer.init();
    }

    public void stop() throws ODEShutdownException {
        if (this._bpelServer != null) {
            try {
                this.__log.debug((Object)"Stopping BPEL Embedded server");
                this._bpelServer.shutdown();
                this._bpelServer = null;
            }
            catch (Exception ex) {
                this.__log.debug((Object)"Error stopping BPEL server");
            }
        }
        if (this._scheduler != null) {
            try {
                this.__log.debug((Object)"Stopping scheduler");
                this._scheduler.shutdown();
                this._scheduler = null;
            }
            catch (Exception ex) {
                this.__log.debug((Object)"Error stopping scheduler");
            }
        }
        if (this._daoCF != null) {
            try {
                this.__log.debug((Object)"Stopping DAO");
                this._daoCF.shutdown();
                this._daoCF = null;
            }
            catch (Exception ex) {
                this.__log.debug((Object)"Error stopping DAO");
            }
        }
        if (this._db != null) {
            try {
                this.__log.debug((Object)"Stopping DB");
                this._db.shutdown();
                this._db = null;
            }
            catch (Exception ex) {
                this.__log.debug((Object)"Error stopping DB");
            }
        }
        if (this._txMgr != null) {
            try {
                this.__log.debug((Object)"Stopping Transaction Manager");
                this._txMgr = null;
            }
            catch (Exception ex) {
                this.__log.debug((Object)"Error stopping Transaction Manager");
            }
        }
    }

    protected Scheduler createScheduler() {
        SimpleScheduler scheduler = new SimpleScheduler(new GUID().toString(), (DatabaseDelegate)new JdbcDelegate(this._db.getDataSource()));
        scheduler.setExecutorService(this._executorService);
        scheduler.setTransactionManager(this._txMgr);
        return scheduler;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public BpelServerImpl getBpelServer() {
        return this._bpelServer;
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public ExecutorService getExecutor() {
        return this._executorService;
    }

    public void deploy(ODEDeployment d, BPELImplementation implementation) {
        try {
            TuscanyProcessConfImpl processConf = new TuscanyProcessConfImpl(implementation);
            this._bpelServer.register((ProcessConf)processConf);
            System.out.println("Completed calling new Process deployment code...");
        }
        catch (Exception ex) {
            String errMsg = ">>> DEPLOY: Unexpected exception: " + ex.getMessage();
            this.__log.debug((Object)errMsg, (Throwable)ex);
            throw new ODEDeploymentException(errMsg, ex);
        }
    }

    public void undeploy(ODEDeployment d) {
    }

    public void registerTuscanyRuntimeComponent(QName processName, RuntimeComponent componentContext) {
        this.tuscanyRuntimeComponents.put(processName, componentContext);
    }

    public RuntimeComponent getTuscanyRuntimeComponent(QName processName) {
        return this.tuscanyRuntimeComponents.get(processName);
    }
}

