/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.ode;

import java.util.concurrent.Callable;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.DOMUtils;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.implementation.bpel.ode.EmbeddedODEServer;
import org.apache.tuscany.sca.implementation.bpel.ode.TuscanyPRC;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ODEExternalService {
    protected final Log __log = LogFactory.getLog(this.getClass());
    private EmbeddedODEServer _server;
    private Scheduler _sched;

    public ODEExternalService(EmbeddedODEServer server) {
        this._server = server;
        this._sched = this._server.getScheduler();
    }

    public void invoke(final PartnerRoleMessageExchange partnerRoleMessageExchange) {
        boolean isTwoWay;
        boolean bl = isTwoWay = partnerRoleMessageExchange.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (isTwoWay) {
            this._sched.registerSynchronizer(new Scheduler.Synchronizer(){

                public void beforeCompletion() {
                }

                public void afterCompletion(boolean success) {
                    if (!success) {
                        return;
                    }
                    ODEExternalService.this._server.getExecutor().submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            block10: {
                                try {
                                    if (!(partnerRoleMessageExchange.getChannel() instanceof TuscanyPRC)) {
                                        throw new IllegalArgumentException("Channel should be an instance of TuscanyPRC");
                                    }
                                    TuscanyPRC channel = (TuscanyPRC)partnerRoleMessageExchange.getChannel();
                                    RuntimeComponent tuscanyRuntimeComponent = ODEExternalService.this._server.getTuscanyRuntimeComponent(channel.getProcessName());
                                    String referenceName = channel.getEndpoint().serviceName.getLocalPart();
                                    Contract runtimeComponentReference = null;
                                    for (ComponentReference reference : tuscanyRuntimeComponent.getReferences()) {
                                        if (!reference.getName().equals(referenceName)) continue;
                                        runtimeComponentReference = (RuntimeComponentReference)reference;
                                        break;
                                    }
                                    if (runtimeComponentReference == null) {
                                        throw new ServiceRuntimeException("Can't find component reference for partner link " + referenceName);
                                    }
                                    RuntimeWire runtimeWire = runtimeComponentReference.getRuntimeWire(runtimeComponentReference.getBindings().get(0));
                                    Operation operation = ODEExternalService.this.findOperation(partnerRoleMessageExchange.getOperation().getName(), (RuntimeComponentReference)runtimeComponentReference);
                                    Element msg = partnerRoleMessageExchange.getRequest().getMessage();
                                    if (msg == null) break block10;
                                    String xml = DOMUtils.domToString((Node)msg);
                                    String payload = DOMUtils.domToString((Node)ODEExternalService.this.getPayload(partnerRoleMessageExchange.getRequest()));
                                    if (ODEExternalService.this.__log.isDebugEnabled()) {
                                        ODEExternalService.this.__log.debug((Object)"Starting invocation of SCA Reference");
                                        ODEExternalService.this.__log.debug((Object)(">>> Original message: " + xml));
                                        ODEExternalService.this.__log.debug((Object)(">>> Payload: " + payload));
                                    }
                                    Object[] args = new Object[]{ODEExternalService.this.getPayload(partnerRoleMessageExchange.getRequest())};
                                    Object result = null;
                                    boolean success = false;
                                    try {
                                        result = runtimeWire.invoke(operation, args);
                                        success = true;
                                    }
                                    catch (Exception e) {
                                        partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.OTHER, e.getMessage(), null);
                                    }
                                    if (ODEExternalService.this.__log.isDebugEnabled()) {
                                        ODEExternalService.this.__log.debug((Object)"SCA Reference invocation finished");
                                        ODEExternalService.this.__log.debug((Object)(">>> Result : " + DOMUtils.domToString((Node)((Element)result))));
                                    }
                                    if (!success) {
                                        return null;
                                    }
                                    ODEExternalService.this.replyTwoWayInvocation(partnerRoleMessageExchange.getMessageExchangeId(), operation, (Element)result);
                                }
                                catch (Throwable t) {
                                    String errmsg = "Error sending message (mex=" + partnerRoleMessageExchange + "): " + t.getMessage();
                                    ODEExternalService.this.__log.error((Object)errmsg, t);
                                }
                            }
                            return null;
                        }
                    });
                }
            });
            partnerRoleMessageExchange.replyAsync();
        } else {
            this._server.getExecutor().submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return null;
                }
            });
            partnerRoleMessageExchange.replyOneWayOk();
        }
    }

    private Operation findOperation(String operationName, RuntimeComponentReference runtimeComponentReference) {
        Operation reseultOperation = null;
        for (Operation operation : runtimeComponentReference.getInterfaceContract().getInterface().getOperations()) {
            if (!operationName.equalsIgnoreCase(operation.getName())) continue;
            reseultOperation = operation;
            break;
        }
        return reseultOperation;
    }

    private Element getPayload(Message odeMessage) {
        Element payload = null;
        Element parameters = odeMessage.getPart("parameters");
        if (parameters != null && parameters.hasChildNodes()) {
            payload = (Element)parameters.getFirstChild();
        }
        return payload;
    }

    private void replyTwoWayInvocation(final String odeMexId, final Operation operation, final Element result) {
        try {
            this._server.getScheduler().execIsolatedTransaction((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    block3: {
                        PartnerRoleMessageExchange odeMex = null;
                        try {
                            odeMex = (PartnerRoleMessageExchange)ODEExternalService.this._server.getBpelServer().getEngine().getMessageExchange(odeMexId);
                            if (odeMex != null) {
                                Message response = ODEExternalService.this.createResponseMessage(odeMex, operation, result);
                                odeMex.reply(response);
                            }
                        }
                        catch (Exception ex) {
                            String errmsg = "Unable to process response: " + ex.getMessage();
                            if (odeMex == null) break block3;
                            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Message createResponseMessage(PartnerRoleMessageExchange partnerRoleMessageExchange, Operation operation, Element invocationResult) {
        Document dom = DOMUtils.newDocument();
        String operationName = operation.getName();
        Part bpelOperationOutputPart = (Part)((WSDLInterface)operation.getInterface()).getPortType().getOperation(operationName, null, null).getOutput().getMessage().getParts().values().iterator().next();
        Element contentMessage = dom.createElement("message");
        Element contentPart = dom.createElement(bpelOperationOutputPart.getName());
        contentPart.appendChild(dom.importNode(invocationResult, true));
        contentMessage.appendChild(contentPart);
        dom.appendChild(contentMessage);
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)"Creating result message:");
            this.__log.debug((Object)(">>>" + DOMUtils.domToString((Node)dom.getDocumentElement())));
        }
        QName id = partnerRoleMessageExchange.getOperation().getOutput().getMessage().getQName();
        Message response = partnerRoleMessageExchange.createMessage(id);
        response.setMessage(dom.getDocumentElement());
        return response;
    }
}

