/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.implementation.bpel.BPELProcessDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELDocumentModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<QName, BPELProcessDefinition> map = new HashMap<QName, BPELProcessDefinition>();

    public BPELDocumentModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved) {
        BPELProcessDefinition process = (BPELProcessDefinition)resolved;
        this.map.put(process.getName(), process);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(((BPELProcessDefinition)resolved).getName());
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        QName qname = ((BPELProcessDefinition)unresolved).getName();
        BPELProcessDefinition resolved = this.map.get(qname);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        for (Import import_ : this.contribution.getImports()) {
            NamespaceImport namespaceImport;
            if (!(import_ instanceof NamespaceImport) || !(namespaceImport = (NamespaceImport)import_).getNamespace().equals(qname.getNamespaceURI()) || (resolved = namespaceImport.getModelResolver().resolveModel(BPELProcessDefinition.class, (BPELProcessDefinition)unresolved)).isUnresolved()) continue;
            return modelClass.cast(resolved);
        }
        return unresolved;
    }
}

