/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.bpel.BPELFactory;
import org.apache.tuscany.sca.implementation.bpel.BPELImplementation;
import org.apache.tuscany.sca.implementation.bpel.BPELProcessDefinition;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkElement;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<BPELImplementation> {
    private static final String PROCESS = "process";
    private static final String IMPLEMENTATION_BPEL = "implementation.bpel";
    private static final QName IMPLEMENTATION_BPEL_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "implementation.bpel");
    private AssemblyFactory assemblyFactory;
    private BPELFactory bpelFactory;
    private WSDLFactory wsdlFactory;
    private Monitor monitor;

    public BPELImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.bpelFactory = modelFactories.getFactory(BPELFactory.class);
        this.monitor = monitor;
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_BPEL_QNAME;
    }

    @Override
    public Class<BPELImplementation> getModelType() {
        return BPELImplementation.class;
    }

    @Override
    public BPELImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        assert (IMPLEMENTATION_BPEL_QNAME.equals(reader.getName()));
        BPELImplementation implementation = null;
        QName process = this.getAttributeValueNS(reader, PROCESS);
        if (process == null) {
            return implementation;
        }
        implementation = this.bpelFactory.createBPELImplementation();
        implementation.setProcess(process);
        implementation.setUnresolved(true);
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_BPEL_QNAME.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(BPELImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        if (implementation != null && implementation.isUnresolved()) {
            implementation.setModelResolver(resolver);
            BPELProcessDefinition processDefinition = this.resolveBPELProcessDefinition(implementation, resolver);
            if (processDefinition.isUnresolved()) {
                this.error("BPELProcessNotFound", implementation, processDefinition.getName());
            } else {
                implementation.setProcessDefinition(processDefinition);
                this.generateComponentType(implementation);
                this.mergeComponentType(resolver, implementation);
                implementation.setUnresolved(false);
            }
        }
    }

    @Override
    public void write(BPELImplementation bpelImplementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", IMPLEMENTATION_BPEL);
        if (bpelImplementation.getProcess() != null) {
            writer.writeAttribute(PROCESS, bpelImplementation.getProcess().toString());
        }
        writer.writeEndElement();
    }

    private BPELProcessDefinition resolveBPELProcessDefinition(BPELImplementation impl, ModelResolver resolver) throws ContributionResolveException {
        QName processName = impl.getProcess();
        BPELProcessDefinition processDefinition = this.bpelFactory.createBPELProcessDefinition();
        processDefinition.setName(processName);
        processDefinition.setUnresolved(true);
        return resolver.resolveModel(BPELProcessDefinition.class, processDefinition);
    }

    private void generateComponentType(BPELImplementation impl) throws ContributionResolveException {
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setUnresolved(true);
        impl.setComponentType(componentType);
        BPELProcessDefinition theProcess = impl.getProcessDefinition();
        List<BPELPartnerLinkElement> partnerLinks = theProcess.getPartnerLinks();
        for (BPELPartnerLinkElement pLink : partnerLinks) {
            if (!pLink.isSCATyped()) continue;
            String scaName = pLink.getSCAName();
            if (pLink.querySCAType().equals("reference")) {
                componentType.getReferences().add(this.generateReference(scaName, pLink.getMyRolePortType(), pLink.getPartnerRolePortType(), theProcess.getInterfaces()));
                continue;
            }
            componentType.getServices().add(this.generateService(scaName, pLink.getMyRolePortType(), pLink.getPartnerRolePortType(), theProcess.getInterfaces()));
        }
    }

    private Reference generateReference(String name, PortType myRolePT, PortType partnerRolePT, Collection<WSDLInterface> theInterfaces) throws ContributionResolveException {
        Reference reference = this.assemblyFactory.createReference();
        WSDLInterfaceContract interfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        PortType callPT = null;
        PortType callbackPT = null;
        if (myRolePT != null) {
            callPT = myRolePT;
            if (partnerRolePT != null && !myRolePT.getQName().equals(partnerRolePT.getQName())) {
                callbackPT = partnerRolePT;
            }
        } else if (partnerRolePT != null) {
            callPT = partnerRolePT;
        }
        if (callPT == null && callbackPT == null) {
            this.error("MyRolePartnerRoleNull", theInterfaces, new Object[0]);
        }
        reference.setName(name);
        reference.setMultiplicity(Multiplicity.ONE_ONE);
        if (callPT != null) {
            WSDLInterface callInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callPT.getQName())) continue;
                callInterface = anInterface;
            }
            if (callInterface == null) {
                this.error("NoInterfaceForPortType", theInterfaces, callPT.getQName().toString());
            } else {
                reference.getInterfaceContract().setInterface(callInterface);
            }
        }
        if (callbackPT != null) {
            WSDLInterface callbackInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callbackPT.getQName())) continue;
                callbackInterface = anInterface;
            }
            if (callbackInterface == null) {
                this.error("NoInterfaceForPortType", theInterfaces, callbackPT.getQName().toString());
            } else {
                reference.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
        }
        return reference;
    }

    private Service generateService(String name, PortType myRolePT, PortType partnerRolePT, Collection<WSDLInterface> theInterfaces) throws ContributionResolveException {
        Service service = this.assemblyFactory.createService();
        WSDLInterfaceContract interfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        service.setName(name);
        PortType callPT = null;
        PortType callbackPT = null;
        if (myRolePT != null) {
            callPT = myRolePT;
            if (partnerRolePT != null && !myRolePT.getQName().equals(partnerRolePT.getQName())) {
                callbackPT = partnerRolePT;
            }
        } else if (partnerRolePT != null) {
            callPT = partnerRolePT;
        }
        if (callPT == null && callbackPT == null) {
            this.error("MyRolePartnerRoleNull", theInterfaces, new Object[0]);
        }
        if (callPT != null) {
            WSDLInterface callInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callPT.getQName())) continue;
                callInterface = anInterface;
            }
            if (callInterface == null) {
                this.error("NoInterfaceForPortType", theInterfaces, callPT.getQName().toString());
            } else {
                service.getInterfaceContract().setInterface(callInterface);
            }
        }
        if (callbackPT != null) {
            WSDLInterface callbackInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callbackPT.getQName())) continue;
                callbackInterface = anInterface;
            }
            if (callbackInterface == null) {
                this.error("NoInterfaceForPortType", theInterfaces, callbackPT.getQName().toString());
            } else {
                service.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
        }
        return service;
    }

    private void mergeComponentType(ModelResolver resolver, BPELImplementation impl) {
        ComponentType componentType = this.getComponentType(resolver, impl);
        if (componentType != null && !componentType.isUnresolved()) {
            HashMap<String, Reference> refMap = new HashMap<String, Reference>();
            for (Reference reference : componentType.getReferences()) {
                refMap.put(reference.getName(), reference);
            }
            for (Reference ref : impl.getReferences()) {
                refMap.put(ref.getName(), ref);
            }
            impl.getReferences().clear();
            impl.getReferences().addAll(refMap.values());
            HashMap<String, Service> serviceMap = new HashMap<String, Service>();
            for (Service service : componentType.getServices()) {
                serviceMap.put(service.getName(), service);
            }
            for (Service svc : impl.getServices()) {
                serviceMap.put(svc.getName(), svc);
            }
            impl.getServices().clear();
            impl.getServices().addAll(serviceMap.values());
            HashMap<String, Property> propMap = new HashMap<String, Property>();
            for (Property property : componentType.getProperties()) {
                propMap.put(property.getName(), property);
            }
            for (Property prop : impl.getProperties()) {
                propMap.put(prop.getName(), prop);
            }
        }
    }

    private ComponentType getComponentType(ModelResolver resolver, BPELImplementation impl) {
        String bpelProcessURI = impl.getProcessDefinition().getURI().toString();
        String componentTypeURI = bpelProcessURI.replace(".bpel", ".componentType");
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setUnresolved(true);
        componentType.setURI(componentTypeURI);
        componentType = resolver.resolveModel(ComponentType.class, componentType);
        if (!componentType.isUnresolved()) {
            return componentType;
        }
        return null;
    }

    private QName getAttributeValueNS(XMLStreamReader reader, String attribute) {
        String fullValue = reader.getAttributeValue(null, attribute);
        if (fullValue == null) {
            this.error("AttributeProcessMissing", reader, new Object[0]);
            return null;
        }
        if (fullValue.trim().charAt(0) == '{') {
            try {
                QName theProcess = QName.valueOf(fullValue);
                return theProcess;
            }
            catch (IllegalArgumentException e) {
                this.error("AttributeWithoutNamespace", reader, attribute, fullValue);
                return null;
            }
        }
        if (fullValue.indexOf(":") < 0) {
            this.error("AttributeWithoutPrefix", reader, attribute, fullValue);
            return null;
        }
        String prefix = fullValue.substring(0, fullValue.indexOf(":"));
        String name = fullValue.substring(fullValue.indexOf(":") + 1);
        String nsUri = reader.getNamespaceContext().getNamespaceURI(prefix);
        if (nsUri == null) {
            this.error("AttributeUnrecognizedNamespace", reader, attribute, fullValue);
            return null;
        }
        return new QName(nsUri, name, prefix);
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }
}

