/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.ejb.xml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.EjbInfo;
import org.apache.tuscany.sca.contribution.jee.EjbModuleInfo;
import org.apache.tuscany.sca.contribution.jee.EjbReferenceInfo;
import org.apache.tuscany.sca.contribution.jee.EnvEntryInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEExtension;
import org.apache.tuscany.sca.contribution.jee.JavaEEOptionalExtension;
import org.apache.tuscany.sca.contribution.jee.impl.EjbModuleInfoImpl;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.ejb.EJBImplementation;
import org.apache.tuscany.sca.implementation.ejb.EJBImplementationFactory;
import org.apache.tuscany.sca.implementation.java.DefaultJavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.PropertyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ReferenceProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ServiceProcessor;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<EJBImplementation> {
    private static final QName IMPLEMENTATION_EJB = new QName("http://www.osoa.org/xmlns/sca/1.0", "implementation.ejb");
    private static final Logger logger = Logger.getLogger(EJBImplementationProcessor.class.getName());
    private AssemblyFactory assemblyFactory;
    private EJBImplementationFactory implementationFactory;
    private Monitor monitor;
    private JavaEEExtension jeeExtension;
    private JavaEEOptionalExtension jeeOptionalExtension;
    private JavaImplementationFactory javaImplementationFactory;
    private JavaInterfaceFactory javaInterfaceFactory;

    public EJBImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = modelFactories.getFactory(EJBImplementationFactory.class);
        this.jeeExtension = modelFactories.getFactory(JavaEEExtension.class);
        this.jeeOptionalExtension = modelFactories.getFactory(JavaEEOptionalExtension.class);
        this.monitor = monitor;
        this.javaImplementationFactory = new DefaultJavaImplementationFactory();
        this.javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        this.javaImplementationFactory.addClassVisitor(new ReferenceProcessor(this.assemblyFactory, this.javaInterfaceFactory));
        this.javaImplementationFactory.addClassVisitor(new PropertyProcessor(this.assemblyFactory));
        this.javaImplementationFactory.addClassVisitor(new ServiceProcessor(this.assemblyFactory, this.javaInterfaceFactory));
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-ejb-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_EJB;
    }

    @Override
    public Class<EJBImplementation> getModelType() {
        return EJBImplementation.class;
    }

    @Override
    public EJBImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        EJBImplementation implementation = this.implementationFactory.createEJBImplementation();
        implementation.setUnresolved(true);
        String ejbLink = this.getString(reader, "ejb-link");
        if (ejbLink != null) {
            implementation.setEJBLink(ejbLink);
            int hashPosition = ejbLink.indexOf(35);
            if (hashPosition >= 0) {
                implementation.setURI(ejbLink.substring(hashPosition + 1));
            } else {
                implementation.setURI(ejbLink);
            }
        } else {
            this.error("EJBLinkAttributeMissing", reader, new Object[0]);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_EJB.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(EJBImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        String uri = implementation.getURI();
        String ejbLink = implementation.getEJBLink();
        if (ejbLink != null) {
            EjbInfo ejbInfo;
            ComponentType ct;
            String module = ejbLink.indexOf(35) != -1 ? ejbLink.substring(0, ejbLink.indexOf(35)) : "";
            String beanName = ejbLink.indexOf(35) != -1 ? ejbLink.substring(ejbLink.indexOf(35) + 1) : ejbLink;
            EjbModuleInfo ejbModuleInfo = new EjbModuleInfoImpl();
            ejbModuleInfo.setUri(URI.create(module));
            ejbModuleInfo = resolver.resolveModel(EjbModuleInfo.class, ejbModuleInfo);
            if (this.jeeExtension != null && (ct = this.jeeExtension.createImplementationEjbComponentType(ejbModuleInfo, beanName)) != null) {
                implementation.getServices().addAll(ct.getServices());
            }
            if (this.jeeOptionalExtension != null && (ct = this.jeeOptionalExtension.createImplementationEjbComponentType(ejbModuleInfo, beanName)) != null) {
                implementation.getReferences().addAll(ct.getReferences());
                implementation.getProperties().addAll(ct.getProperties());
                ArrayList<String> propertyNames = new ArrayList<String>();
                for (Property prop : ct.getProperties()) {
                    propertyNames.add(prop.getName());
                }
                EjbInfo ejbInfo2 = ejbModuleInfo.getEjbInfo(uri);
                for (Map.Entry<String, Object> entry : ejbInfo2.ejbReferences.entrySet()) {
                    EjbReferenceInfo ejbRef = (EjbReferenceInfo)entry.getValue();
                    implementation.getOptExtensionReferenceInjectionPoints().put(ejbRef.injectionTarget, ejbRef.businessInterface);
                }
                for (Map.Entry<String, Object> entry : ejbInfo2.envEntries.entrySet()) {
                    EnvEntryInfo envEntry = (EnvEntryInfo)entry.getValue();
                    if (!propertyNames.contains(envEntry.name.replace("/", "_"))) continue;
                    implementation.getOptExtensionPropertyInjectionPoints().put(envEntry.name, envEntry.type);
                }
            }
            if ((ejbInfo = ejbModuleInfo.getEjbInfo(uri)) == null) {
                logger.severe("EJB " + uri + " is not found in the module");
            } else {
                Class<?> beanClass = ejbInfo.beanClass;
                try {
                    JavaImplementation ji = this.javaImplementationFactory.createJavaImplementation(beanClass);
                    implementation.getReferences().addAll(ji.getReferences());
                    implementation.getProperties().addAll(ji.getProperties());
                    implementation.getServices().addAll(ji.getServices());
                    for (Map.Entry<String, Object> entry : ji.getReferenceMembers().entrySet()) {
                        implementation.getReferenceInjectionPoints().put(entry.getKey(), (JavaElementImpl)entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : ji.getPropertyMembers().entrySet()) {
                        implementation.getPropertyInjectionPoints().put(entry.getKey(), (JavaElementImpl)entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : ji.getResources().entrySet()) {
                        implementation.getResourceInjectionPoints().put(entry.getKey(), (JavaResourceImpl)entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : ji.getCallbackMembers().entrySet()) {
                        implementation.getCallbackInjectionPoints().put(entry.getKey(), (Collection<JavaElementImpl>)entry.getValue());
                    }
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
            }
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI(uri + ".componentType");
            componentType = resolver.resolveModel(ComponentType.class, componentType);
            if (!componentType.isUnresolved()) {
                implementation.getServices().addAll(componentType.getServices());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getProperties().addAll(componentType.getProperties());
            }
        }
        implementation.setUnresolved(false);
    }

    @Override
    public void write(EJBImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, IMPLEMENTATION_EJB.getNamespaceURI(), IMPLEMENTATION_EJB.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("ejb-link", implementation.getEJBLink()));
        this.writeEnd(writer);
    }
}

