/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.JavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassIntrospectorImpl {
    private List<JavaClassVisitor> visitors;

    public JavaClassIntrospectorImpl(List<JavaClassVisitor> visitors) {
        this.visitors = visitors;
    }

    public void introspectClass(JavaImplementation type, Class<?> clazz) throws IntrospectionException {
        for (JavaClassVisitor extension : this.visitors) {
            extension.visitClass(clazz, type);
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            for (JavaClassVisitor extension : this.visitors) {
                extension.visitConstructor(constructor, type);
                JavaConstructorImpl definition = type.getConstructors().get(constructor);
                if (definition == null) continue;
                for (JavaParameterImpl p : definition.getParameters()) {
                    extension.visitConstructorParameter(p, type);
                }
            }
        }
        Set<Field> fields = JavaIntrospectionHelper.getAllPublicAndProtectedFields(clazz, true);
        for (Field field : fields) {
            for (JavaClassVisitor extension : this.visitors) {
                extension.visitField(field, type);
            }
        }
        Set<Field> privateFields = JavaIntrospectionHelper.getPrivateFields(clazz);
        for (Field field : privateFields) {
            for (JavaClassVisitor processor : this.visitors) {
                processor.visitField(field, type);
            }
        }
        Set<Method> methods = JavaIntrospectionHelper.getAllUniquePublicProtectedMethods(clazz, true);
        for (Method method : methods) {
            for (JavaClassVisitor processor : this.visitors) {
                processor.visitMethod(method, type);
            }
        }
        Set<Method> privateMethods = JavaIntrospectionHelper.getPrivateMethods(clazz);
        for (Method method : privateMethods) {
            for (JavaClassVisitor processor : this.visitors) {
                processor.visitMethod(method, type);
            }
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            this.visitSuperClass(superClass, type);
        }
        for (JavaClassVisitor extension : this.visitors) {
            extension.visitEnd(clazz, type);
        }
    }

    private void visitSuperClass(Class<?> clazz, JavaImplementation type) throws IntrospectionException {
        if (!Object.class.equals(clazz)) {
            for (JavaClassVisitor extension : this.visitors) {
                extension.visitSuperClass(clazz, type);
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                this.visitSuperClass(clazz, type);
            }
        }
    }
}

