/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElementImpl {
    private AnnotatedElement anchor;
    private ElementType elementType;
    private WeakReference<Class<?>> type;
    private WeakReference<Type> genericType;
    private int index = -1;
    private String name;
    private Class<? extends Annotation> classifer;

    public JavaElementImpl(Package pkg) {
        this.anchor = pkg;
        this.elementType = ElementType.PACKAGE;
        this.name = pkg.getName();
    }

    public JavaElementImpl(Class<?> cls) {
        this.anchor = cls;
        this.elementType = ElementType.TYPE;
        this.type = new WeakReference(cls);
        this.genericType = new WeakReference(cls);
        this.name = cls.getName();
    }

    public JavaElementImpl(Field field) {
        this.anchor = field;
        this.elementType = ElementType.FIELD;
        this.type = new WeakReference(field.getType());
        this.genericType = new WeakReference<Type>(field.getGenericType());
        this.name = field.getName();
    }

    public JavaElementImpl(Constructor<?> constructor, int index) {
        this.anchor = constructor;
        this.elementType = ElementType.PARAMETER;
        this.type = new WeakReference(constructor.getParameterTypes()[index]);
        this.genericType = new WeakReference<Type>(constructor.getGenericParameterTypes()[index]);
        this.index = index;
        this.name = "";
    }

    public JavaElementImpl(Method method, int index) {
        this.anchor = method;
        this.elementType = ElementType.PARAMETER;
        this.type = new WeakReference(method.getParameterTypes()[index]);
        this.genericType = new WeakReference<Type>(method.getGenericParameterTypes()[index]);
        this.index = index;
        this.name = "";
    }

    public JavaElementImpl(String name, Class<?> type, Class<? extends Annotation> classifer) {
        this.type = new WeakReference(type);
        this.name = name;
        this.classifer = classifer;
    }

    public AnnotatedElement getAnchor() {
        return this.anchor;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public Type getGenericType() {
        return (Type)this.genericType.get();
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getType() {
        return (Class)this.type.get();
    }

    public Annotation[] getAnnotations() {
        if (this.elementType == ElementType.PARAMETER) {
            if (this.anchor instanceof Method) {
                return ((Method)this.anchor).getAnnotations();
            }
            if (this.anchor instanceof Constructor) {
                return ((Constructor)this.anchor).getParameterAnnotations()[this.index];
            }
        }
        return this.anchor.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation a : this.getAnnotations()) {
            if (a.annotationType() != annotationType) continue;
            return (T)((Annotation)annotationType.cast(a));
        }
        return null;
    }

    public String toString() {
        return this.anchor.toString() + (this.elementType == ElementType.PARAMETER ? "[" + this.index + "]" : "");
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.anchor == null ? 0 : this.anchor.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaElementImpl other = (JavaElementImpl)obj;
        if (this.anchor == null ? other.anchor != null : !this.anchor.equals(other.anchor)) {
            return false;
        }
        return this.index == other.index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<? extends Annotation> getClassifer() {
        return this.classifer;
    }

    public void setClassifer(Class<? extends Annotation> classifer) {
        this.classifer = classifer;
    }
}

