/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.impl.JavaClassIntrospectorImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaImplementationImpl;
import org.apache.tuscany.sca.implementation.java.introspect.JavaClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaImplementationFactoryImpl
implements JavaImplementationFactory {
    private List<JavaClassVisitor> visitors = new ArrayList<JavaClassVisitor>();
    private JavaClassIntrospectorImpl introspector = new JavaClassIntrospectorImpl(this.visitors);

    @Override
    public JavaImplementation createJavaImplementation() {
        JavaImplementationImpl javaImplementation = new JavaImplementationImpl();
        return javaImplementation;
    }

    @Override
    public JavaImplementation createJavaImplementation(Class<?> implementationClass) throws IntrospectionException {
        JavaImplementation javaImplementation = this.createJavaImplementation();
        this.introspector.introspectClass(javaImplementation, implementationClass);
        return javaImplementation;
    }

    @Override
    public void createJavaImplementation(JavaImplementation javaImplementation, Class<?> implementationClass) throws IntrospectionException {
        this.introspector.introspectClass(javaImplementation, implementationClass);
    }

    @Override
    public void addClassVisitor(JavaClassVisitor visitor) {
        for (JavaClassVisitor tmpVisitor : this.visitors) {
            if (tmpVisitor.getClass() != visitor.getClass()) continue;
            return;
        }
        this.visitors.add(visitor);
    }

    @Override
    public void removeClassVisitor(JavaClassVisitor visitor) {
        this.visitors.remove(visitor);
    }

    @Override
    public List<JavaClassVisitor> getClassVisitors() {
        return this.visitors;
    }
}

