/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.Injector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjector<T>
implements Injector<T> {
    private final Method method;
    private final ObjectFactory<?> objectFactory;

    public MethodInjector(Method aMethod, ObjectFactory<?> objectFactory) {
        assert (aMethod != null);
        assert (objectFactory != null);
        this.method = aMethod;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                MethodInjector.this.method.setAccessible(true);
                return null;
            }
        });
        this.objectFactory = objectFactory;
    }

    @Override
    public void inject(T instance) throws ObjectCreationException {
        try {
            this.method.invoke(instance, this.objectFactory.getInstance());
        }
        catch (IllegalAccessException e) {
            throw new ObjectCreationException("Method is not accessible [" + this.method + "]", e);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectCreationException("Exception thrown by setter: " + this.method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectCreationException("Exception thrown by setter: " + this.method.getName(), e);
        }
    }
}

