/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Constructor;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorProcessor
extends BaseJavaClassVisitor {
    public ConstructorProcessor(AssemblyFactory factory) {
        super(factory);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        Constructor<?>[] ctors = clazz.getConstructors();
        boolean found = false;
        for (Constructor<?> constructor : ctors) {
            JavaConstructorImpl definition = new JavaConstructorImpl(constructor);
            type.getConstructors().put(constructor, definition);
            if (constructor.getAnnotation(org.osoa.sca.annotations.Constructor.class) == null) continue;
            if (found) {
                throw new DuplicateConstructorException("Multiple constructors marked with @Constructor", constructor);
            }
            found = true;
            type.setConstructor(definition);
        }
    }

    @Override
    public <T> void visitConstructor(Constructor<T> constructor, JavaImplementation type) throws IntrospectionException {
        boolean isDefault;
        org.osoa.sca.annotations.Constructor annotation = constructor.getAnnotation(org.osoa.sca.annotations.Constructor.class);
        if (annotation == null) {
            return;
        }
        JavaConstructorImpl<Object> definition = type.getConstructor();
        if (definition == null) {
            definition = new JavaConstructorImpl<T>(constructor);
            type.setConstructor(definition);
        }
        JavaParameterImpl[] parameters = definition.getParameters();
        String[] value = annotation.value();
        boolean bl = isDefault = value.length == 0 || value.length == 1 && "".equals(value[0]);
        if (!isDefault && value.length != parameters.length) {
            throw new InvalidConstructorException("Invalid Number of names in @Constructor");
        }
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i].setName(i < value.length ? value[i] : "");
        }
        type.setConstructor(definition);
    }
}

