/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalContextException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.introspect.impl.Resource;
import org.osoa.sca.annotations.ConversationID;

public class ConversationIDProcessor
extends BaseJavaClassVisitor {
    public ConversationIDProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        if (method.getAnnotation(ConversationID.class) == null) {
            return;
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalContextException("ConversationID setter must have one parameter", method);
        }
        String name = JavaIntrospectionHelper.toPropertyName(method.getName());
        JavaElementImpl element = new JavaElementImpl(method, 0);
        element.setName(name);
        element.setClassifer(Resource.class);
        JavaResourceImpl resource = new JavaResourceImpl(element);
        type.getResources().put(resource.getName(), resource);
    }

    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        if (field.getAnnotation(ConversationID.class) == null) {
            return;
        }
        JavaElementImpl element = new JavaElementImpl(field);
        element.setClassifer(Resource.class);
        JavaResourceImpl resource = new JavaResourceImpl(element);
        type.getResources().put(resource.getName(), resource);
    }
}

