/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaScopeImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConversationalImplementation;
import org.osoa.sca.annotations.ConversationAttributes;
import org.osoa.sca.annotations.ConversationID;
import org.osoa.sca.annotations.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationProcessor
extends BaseJavaClassVisitor {
    private static final String SECONDS = " SECONDS";
    private static final String MINUTES = " MINUTES";
    private static final String HOURS = " HOURS";
    private static final String DAYS = " DAYS";
    private static final String YEARS = " YEARS";

    public ConversationProcessor(AssemblyFactory factory) {
        super(factory);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        ConversationAttributes conversation = clazz.getAnnotation(ConversationAttributes.class);
        if (conversation == null) {
            return;
        }
        Scope scope = clazz.getAnnotation(Scope.class);
        if (scope == null) {
            type.setJavaScope(JavaScopeImpl.CONVERSATION);
        } else if (conversation != null) {
            String maxAgeVal = conversation.maxAge();
            String maxIdleTimeVal = conversation.maxIdleTime();
            try {
                if (maxAgeVal.length() > 0) {
                    long maxAge = this.convertTimeMillis(maxAgeVal);
                    type.setMaxAge(maxAge);
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidConversationalImplementation("Invalid maximum age", e);
            }
            try {
                if (maxIdleTimeVal.length() > 0) {
                    long maxIdleTime = this.convertTimeMillis(maxIdleTimeVal);
                    type.setMaxIdleTime(maxIdleTime);
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidConversationalImplementation("Invalid maximum idle time", e);
            }
        }
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        ConversationID conversationID = method.getAnnotation(ConversationID.class);
        if (conversationID == null) {
            return;
        }
        type.addConversationIDMember(method);
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        ConversationID conversationID = field.getAnnotation(ConversationID.class);
        if (conversationID == null) {
            return;
        }
        type.addConversationIDMember(field);
    }

    protected long convertTimeMillis(String expr) throws NumberFormatException {
        int i = (expr = expr.trim().toUpperCase()).lastIndexOf(SECONDS);
        if (i >= 0) {
            String units = expr.substring(0, i);
            return Long.parseLong(units) * 1000L;
        }
        i = expr.lastIndexOf(MINUTES);
        if (i >= 0) {
            String units = expr.substring(0, i);
            return Long.parseLong(units) * 60000L;
        }
        i = expr.lastIndexOf(HOURS);
        if (i >= 0) {
            String units = expr.substring(0, i);
            return Long.parseLong(units) * 3600000L;
        }
        i = expr.lastIndexOf(DAYS);
        if (i >= 0) {
            String units = expr.substring(0, i);
            return Long.parseLong(units) * 86400000L;
        }
        i = expr.lastIndexOf(YEARS);
        if (i >= 0) {
            String units = expr.substring(0, i);
            return Long.parseLong(units) * 31556926000L;
        }
        return Long.parseLong(expr) * 1000L;
    }
}

