/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateInitException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalInitException;
import org.osoa.sca.annotations.Init;

public class InitProcessor
extends BaseJavaClassVisitor {
    public InitProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Init annotation = method.getAnnotation(Init.class);
        if (annotation == null) {
            return;
        }
        if (method.getParameterTypes().length != 0) {
            throw new IllegalInitException("Initializer must not have argments", method);
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalInitException("Initializer must return void.", method);
        }
        if (type.getInitMethod() != null) {
            throw new DuplicateInitException("More than one initializer found on implementaton");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalInitException("Initializer must be a public method. Invalid annotation @Init found on " + method);
        }
        type.setInitMethod(method);
    }
}

