/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Method;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.policy.Policy;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.authorization.AuthorizationPolicy;
import org.apache.tuscany.sca.policy.identity.SecurityIdentityPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR250PolicyProcessor
extends BaseJavaClassVisitor {
    private static final QName RUN_AS = new QName("http://www.osoa.org/xmlns/sca/1.0", "runAs");
    private static final QName ALLOW = new QName("http://www.osoa.org/xmlns/sca/1.0", "allow");
    private static final QName PERMIT_ALL = new QName("http://www.osoa.org/xmlns/sca/1.0", "permitAll");
    private static final QName DENY_ALL = new QName("http://www.osoa.org/xmlns/sca/1.0", "denyAll");
    private PolicyFactory policyFactory;

    public JSR250PolicyProcessor(AssemblyFactory assemblyFactory, PolicyFactory policyFactory) {
        super(assemblyFactory);
        this.policyFactory = policyFactory;
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        PermitAll permitAll;
        RolesAllowed rolesAllowed;
        PolicySet policySet;
        Policy policy;
        RunAs runAs = clazz.getAnnotation(RunAs.class);
        if (runAs != null) {
            String roleName = runAs.value();
            if (roleName == null) {
                // empty if block
            }
            policy = new SecurityIdentityPolicy();
            ((SecurityIdentityPolicy)policy).setRunAsRole(roleName);
            policySet = this.policyFactory.createPolicySet();
            policySet.setName(RUN_AS);
            policySet.getPolicies().add(policy);
            policySet.setUnresolved(false);
            ((PolicySetAttachPoint)((Object)type)).getPolicySets().add(policySet);
        }
        if ((rolesAllowed = clazz.getAnnotation(RolesAllowed.class)) != null) {
            if (rolesAllowed.value().length == 0) {
                // empty if block
            }
            policy = new AuthorizationPolicy();
            ((AuthorizationPolicy)policy).setAccessControl(AuthorizationPolicy.AcessControl.allow);
            for (String role : rolesAllowed.value()) {
                ((AuthorizationPolicy)policy).getRoleNames().add(role);
            }
            policySet = this.policyFactory.createPolicySet();
            policySet.setName(ALLOW);
            policySet.getPolicies().add(policy);
            policySet.setUnresolved(false);
            ((PolicySetAttachPoint)((Object)type)).getPolicySets().add(policySet);
        }
        if ((permitAll = clazz.getAnnotation(PermitAll.class)) != null) {
            AuthorizationPolicy policy2 = new AuthorizationPolicy();
            policy2.setAccessControl(AuthorizationPolicy.AcessControl.permitAll);
            PolicySet policySet2 = this.policyFactory.createPolicySet();
            policySet2.setName(PERMIT_ALL);
            policySet2.getPolicies().add(policy2);
            policySet2.setUnresolved(false);
            ((PolicySetAttachPoint)((Object)type)).getPolicySets().add(policySet2);
        }
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        DenyAll denyAll;
        PermitAll permitAll;
        RolesAllowed rolesAllowed = method.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            if (rolesAllowed.value().length == 0) {
                // empty if block
            }
            AuthorizationPolicy policy = new AuthorizationPolicy();
            policy.setAccessControl(AuthorizationPolicy.AcessControl.allow);
            for (String role : rolesAllowed.value()) {
                policy.getRoleNames().add(role);
            }
            ConfiguredOperation confOp = this.assemblyFactory.createConfiguredOperation();
            confOp.setName(method.getName());
            ((OperationsConfigurator)((Object)type)).getConfiguredOperations().add(confOp);
            PolicySet policySet = this.policyFactory.createPolicySet();
            policySet.setName(ALLOW);
            policySet.getPolicies().add(policy);
            policySet.setUnresolved(false);
            confOp.getPolicySets().add(policySet);
        }
        if ((permitAll = method.getAnnotation(PermitAll.class)) != null) {
            AuthorizationPolicy policy = new AuthorizationPolicy();
            policy.setAccessControl(AuthorizationPolicy.AcessControl.permitAll);
            ConfiguredOperation confOp = this.assemblyFactory.createConfiguredOperation();
            confOp.setName(method.getName());
            ((OperationsConfigurator)((Object)type)).getConfiguredOperations().add(confOp);
            PolicySet policySet = this.policyFactory.createPolicySet();
            policySet.setName(PERMIT_ALL);
            policySet.getPolicies().add(policy);
            policySet.setUnresolved(false);
            confOp.getPolicySets().add(policySet);
        }
        if ((denyAll = method.getAnnotation(DenyAll.class)) != null) {
            AuthorizationPolicy policy = new AuthorizationPolicy();
            policy.setAccessControl(AuthorizationPolicy.AcessControl.denyAll);
            ConfiguredOperation confOp = this.assemblyFactory.createConfiguredOperation();
            confOp.setName(method.getName());
            ((OperationsConfigurator)((Object)type)).getConfiguredOperations().add(confOp);
            PolicySet policySet = this.policyFactory.createPolicySet();
            policySet.setName(DENY_ALL);
            policySet.getPolicies().add(policy);
            policySet.setUnresolved(false);
            confOp.getPolicySets().add(policySet);
        }
    }
}

