/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.osoa.sca.annotations.PolicySets;
import org.osoa.sca.annotations.Requires;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyProcessor
extends BaseJavaClassVisitor {
    private PolicyFactory policyFactory;

    public PolicyProcessor(AssemblyFactory assemblyFactory, PolicyFactory policyFactory) {
        super(assemblyFactory);
        this.policyFactory = policyFactory;
    }

    private QName getQName(String intentName) {
        int i;
        QName qname = intentName.startsWith("{") ? ((i = intentName.indexOf(125)) != -1 ? new QName(intentName.substring(1, i), intentName.substring(i + 1)) : new QName("", intentName)) : new QName("", intentName);
        return qname;
    }

    private void readIntentsAndPolicySets(Class<?> clazz, List<Intent> requiredIntents, List<PolicySet> policySets) {
        String[] policySetNames;
        PolicySets policySetAnnotation;
        String[] intentNames;
        Requires intentAnnotation = clazz.getAnnotation(Requires.class);
        if (intentAnnotation != null && (intentNames = intentAnnotation.value()).length != 0) {
            for (String intentName : intentNames) {
                Intent intent = this.policyFactory.createIntent();
                intent.setName(this.getQName(intentName));
                requiredIntents.add(intent);
            }
        }
        if ((policySetAnnotation = clazz.getAnnotation(PolicySets.class)) != null && (policySetNames = policySetAnnotation.value()).length != 0) {
            for (String policySetName : policySetNames) {
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(this.getQName(policySetName));
                policySets.add(policySet);
            }
        }
    }

    private void readIntents(Requires intentAnnotation, List<Intent> requiredIntents) {
        String[] intentNames;
        if (intentAnnotation != null && (intentNames = intentAnnotation.value()).length != 0) {
            for (String intentName : intentNames) {
                Intent intent = this.policyFactory.createIntent();
                intent.setName(this.getQName(intentName));
                requiredIntents.add(intent);
            }
        }
    }

    private void readPolicySets(PolicySets policySetAnnotation, List<PolicySet> policySets) {
        String[] policySetNames;
        if (policySetAnnotation != null && (policySetNames = policySetAnnotation.value()).length != 0) {
            for (String policySetName : policySetNames) {
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(this.getQName(policySetName));
                policySets.add(policySet);
            }
        }
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        if (type instanceof PolicySetAttachPoint) {
            this.readIntentsAndPolicySets(clazz, ((PolicySetAttachPoint)((Object)type)).getRequiredIntents(), ((PolicySetAttachPoint)((Object)type)).getPolicySets());
        }
        for (Service service : type.getServices()) {
            JavaInterface javaCallbackInterface;
            JavaInterface javaInterface;
            InterfaceContract interfaceContract = service.getInterfaceContract();
            if (!(interfaceContract instanceof JavaInterfaceContract)) continue;
            JavaInterfaceContract javaInterfaceContract = (JavaInterfaceContract)interfaceContract;
            if (javaInterfaceContract.getInterface() != null && (javaInterface = (JavaInterface)javaInterfaceContract.getInterface()).getJavaClass() != null) {
                this.readIntentsAndPolicySets(javaInterface.getJavaClass(), service.getRequiredIntents(), service.getPolicySets());
                Method[] methods = javaInterface.getJavaClass().getMethods();
                ConfiguredOperation confOp = null;
                for (Method method : methods) {
                    if (method.getAnnotation(Requires.class) == null && method.getAnnotation(PolicySets.class) == null) continue;
                    confOp = this.assemblyFactory.createConfiguredOperation();
                    confOp.setName(method.getName());
                    confOp.setContractName(service.getName());
                    service.getConfiguredOperations().add(confOp);
                    this.readIntents(method.getAnnotation(Requires.class), confOp.getRequiredIntents());
                    this.readPolicySets(method.getAnnotation(PolicySets.class), confOp.getPolicySets());
                }
            }
            if (javaInterfaceContract.getCallbackInterface() == null || (javaCallbackInterface = (JavaInterface)javaInterfaceContract.getCallbackInterface()).getJavaClass() == null) continue;
            Callback callback = service.getCallback();
            if (callback == null) {
                callback = this.assemblyFactory.createCallback();
                service.setCallback(callback);
            }
            this.readIntentsAndPolicySets(javaCallbackInterface.getJavaClass(), callback.getRequiredIntents(), callback.getPolicySets());
            Method[] methods = javaCallbackInterface.getJavaClass().getMethods();
            ConfiguredOperation confOp = null;
            for (Method method : methods) {
                confOp = this.assemblyFactory.createConfiguredOperation();
                confOp.setName(method.getName());
                callback.getConfiguredOperations().add(confOp);
                this.readIntents(method.getAnnotation(Requires.class), confOp.getRequiredIntents());
                this.readPolicySets(method.getAnnotation(PolicySets.class), confOp.getPolicySets());
            }
        }
    }

    private Reference getReference(Method method, JavaImplementation type) {
        org.osoa.sca.annotations.Reference annotation = method.getAnnotation(org.osoa.sca.annotations.Reference.class);
        if (annotation != null && JavaIntrospectionHelper.isSetter(method)) {
            String name = annotation.name();
            if ("".equals(name)) {
                name = JavaIntrospectionHelper.toPropertyName(method.getName());
            }
            return this.getReferenceByName(name, type);
        }
        return null;
    }

    private Reference getReferenceByName(String name, JavaImplementation type) {
        for (Reference reference : type.getReferences()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        org.osoa.sca.annotations.Reference annotation = field.getAnnotation(org.osoa.sca.annotations.Reference.class);
        if (annotation == null) {
            return;
        }
        String name = annotation.name();
        if ("".equals(name)) {
            name = field.getName();
        }
        Reference reference = null;
        reference = this.getReferenceByName(name, type);
        if (reference != null) {
            this.readIntents(field.getAnnotation(Requires.class), reference.getRequiredIntents());
            this.readPolicySets(field.getAnnotation(PolicySets.class), reference.getPolicySets());
        }
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Reference reference = null;
        reference = this.getReference(method, type);
        if (reference != null) {
            this.readIntents(method.getAnnotation(Requires.class), reference.getRequiredIntents());
            this.readPolicySets(method.getAnnotation(PolicySets.class), reference.getPolicySets());
        } else if (type instanceof OperationsConfigurator && (method.getAnnotation(Requires.class) != null || method.getAnnotation(PolicySets.class) != null) && type instanceof PolicySetAttachPoint) {
            ConfiguredOperation confOp = this.assemblyFactory.createConfiguredOperation();
            confOp.setName(method.getName());
            ((OperationsConfigurator)((Object)type)).getConfiguredOperations().add(confOp);
            this.readIntents(method.getAnnotation(Requires.class), confOp.getRequiredIntents());
            this.readPolicySets(method.getAnnotation(PolicySets.class), confOp.getPolicySets());
        }
    }
}

