/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateReferenceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalReferenceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.osoa.sca.CallableReference;

public class ReferenceProcessor
extends BaseJavaClassVisitor {
    private JavaInterfaceFactory javaFactory;

    public ReferenceProcessor(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        super(assemblyFactory);
        this.javaFactory = javaFactory;
    }

    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        JavaElementImpl ref;
        org.osoa.sca.annotations.Reference annotation = method.getAnnotation(org.osoa.sca.annotations.Reference.class);
        if (annotation == null) {
            return;
        }
        if (!JavaIntrospectionHelper.isSetter(method)) {
            throw new IllegalReferenceException("Annotated method is not a setter: " + method, method);
        }
        String name = annotation.name();
        if ("".equals(name)) {
            name = JavaIntrospectionHelper.toPropertyName(method.getName());
        }
        if ((ref = type.getReferenceMembers().get(name)) != null && ref.getElementType() != ElementType.FIELD) {
            throw new DuplicateReferenceException(name);
        }
        this.removeReference(ref, type);
        JavaElementImpl element = new JavaElementImpl(method, 0);
        Reference reference = this.createReference(element, name);
        type.getReferences().add(reference);
        type.getReferenceMembers().put(name, element);
    }

    private boolean removeReference(JavaElementImpl ref, JavaImplementation type) {
        if (ref == null) {
            return false;
        }
        List<Reference> refs = type.getReferences();
        for (int i = 0; i < refs.size(); ++i) {
            if (!refs.get(i).getName().equals(ref.getName())) continue;
            refs.remove(i);
            return true;
        }
        return false;
    }

    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        JavaElementImpl ref;
        org.osoa.sca.annotations.Reference annotation = field.getAnnotation(org.osoa.sca.annotations.Reference.class);
        if (annotation == null) {
            return;
        }
        String name = annotation.name();
        if ("".equals(name)) {
            name = field.getName();
        }
        if ((ref = type.getReferenceMembers().get(name)) != null && ref.getElementType() == ElementType.FIELD) {
            throw new DuplicateReferenceException(name);
        }
        if (ref == null) {
            JavaElementImpl element = new JavaElementImpl(field);
            Reference reference = this.createReference(element, name);
            type.getReferences().add(reference);
            type.getReferenceMembers().put(name, element);
        }
    }

    public void visitConstructorParameter(JavaParameterImpl parameter, JavaImplementation type) throws IntrospectionException {
        org.osoa.sca.annotations.Reference refAnnotation = parameter.getAnnotation(org.osoa.sca.annotations.Reference.class);
        if (refAnnotation == null) {
            return;
        }
        String paramName = parameter.getName();
        String name = this.getReferenceName(paramName, parameter.getIndex(), refAnnotation.name());
        JavaElementImpl ref = type.getReferenceMembers().get(name);
        if (ref != null && ref.getElementType() != ElementType.FIELD) {
            throw new DuplicateReferenceException(name);
        }
        this.removeReference(ref, type);
        Reference reference = this.createReference(parameter, name);
        type.getReferences().add(reference);
        type.getReferenceMembers().put(name, parameter);
        parameter.setClassifer(org.osoa.sca.annotations.Reference.class);
        parameter.setName(name);
    }

    private String getReferenceName(String paramName, int pos, String name) throws InvalidConstructorException {
        if ("".equals(name)) {
            name = paramName;
        }
        if ("".equals(name)) {
            return "_ref" + pos;
        }
        if (!"".equals(paramName) && !name.equals(paramName)) {
            throw new InvalidConstructorException("Mismatching names specified for reference parameter " + pos);
        }
        return name;
    }

    private Reference createReference(JavaElementImpl element, String name) throws IntrospectionException {
        Reference reference = this.assemblyFactory.createReference();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        boolean required = true;
        org.osoa.sca.annotations.Reference ref = element.getAnnotation(org.osoa.sca.annotations.Reference.class);
        if (ref != null) {
            required = ref.required();
        }
        reference.setName(name);
        Class<?> rawType = element.getType();
        if (rawType.isArray() || Collection.class.isAssignableFrom(rawType)) {
            if (required) {
                reference.setMultiplicity(Multiplicity.ONE_N);
            } else {
                reference.setMultiplicity(Multiplicity.ZERO_N);
            }
        } else if (required) {
            reference.setMultiplicity(Multiplicity.ONE_ONE);
        } else {
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
        }
        Type genericType = element.getGenericType();
        Class<?> baseType = JavaIntrospectionHelper.getBaseType(rawType, genericType);
        if (CallableReference.class.isAssignableFrom(baseType)) {
            if (Collection.class.isAssignableFrom(rawType)) {
                genericType = JavaIntrospectionHelper.getParameterType(genericType);
            }
            baseType = JavaIntrospectionHelper.getBusinessInterface(baseType, genericType);
        }
        try {
            JavaInterface callInterface = this.javaFactory.createJavaInterface(baseType);
            reference.getInterfaceContract().setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
                reference.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
        }
        catch (InvalidInterfaceException e) {
            throw new IntrospectionException(e);
        }
        return reference;
    }
}

