/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateResourceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalResourceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidResourceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.introspect.impl.Resource;

public class ResourceProcessor
extends BaseJavaClassVisitor {
    public ResourceProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Resource annotation = method.getAnnotation(Resource.class);
        if (annotation == null) {
            return;
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalResourceException("Resource setter must have one parameter", method);
        }
        String name = annotation.name();
        if (name.length() < 1) {
            name = JavaIntrospectionHelper.toPropertyName(method.getName());
        }
        if (type.getResources().get(name) != null) {
            throw new DuplicateResourceException(name);
        }
        String mappedName = annotation.mappedName();
        JavaResourceImpl resource = this.createResource(name, new JavaElementImpl(method, 0));
        resource.setOptional(annotation.optional());
        if (mappedName.length() > 0) {
            resource.setMappedName(mappedName);
        }
        type.getResources().put(resource.getName(), resource);
    }

    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        Resource annotation = field.getAnnotation(Resource.class);
        if (annotation == null) {
            return;
        }
        String name = annotation.name();
        if (name.length() < 1) {
            name = field.getName();
        }
        if (type.getResources().get(name) != null) {
            throw new DuplicateResourceException(name);
        }
        String mappedName = annotation.mappedName();
        JavaResourceImpl resource = this.createResource(name, new JavaElementImpl(field));
        resource.setOptional(annotation.optional());
        if (mappedName.length() > 0) {
            resource.setMappedName(mappedName);
        }
        type.getResources().put(resource.getName(), resource);
    }

    public JavaResourceImpl createResource(String name, JavaElementImpl element) {
        element.setClassifer(Resource.class);
        element.setName(name);
        return new JavaResourceImpl(element);
    }

    public void visitConstructorParameter(JavaParameterImpl parameter, JavaImplementation type) throws IntrospectionException {
        Resource resourceAnnotation = parameter.getAnnotation(Resource.class);
        if (resourceAnnotation != null) {
            String name = resourceAnnotation.name();
            if ("".equals(name)) {
                name = parameter.getName();
            }
            if ("".equals(name)) {
                throw new InvalidResourceException("Missing resource name", (Member)((Object)parameter.getAnchor()));
            }
            if (!"".equals(parameter.getName()) && !name.equals(parameter.getName())) {
                throw new InvalidConstructorException("Mismatched resource name: " + parameter);
            }
            if (type.getResources().get(name) != null) {
                throw new DuplicateResourceException(name);
            }
            String mappedName = resourceAnnotation.mappedName();
            JavaResourceImpl resource = this.createResource(name, parameter);
            resource.setOptional(resourceAnnotation.optional());
            if (mappedName.length() > 0) {
                resource.setMappedName(mappedName);
            }
            type.getResources().put(resource.getName(), resource);
        }
    }
}

