/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaScopeImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.osoa.sca.annotations.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeProcessor
extends BaseJavaClassVisitor {
    public ScopeProcessor(AssemblyFactory factory) {
        super(factory);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        Scope annotation = clazz.getAnnotation(Scope.class);
        if (annotation == null) {
            type.setJavaScope(JavaScopeImpl.STATELESS);
            return;
        }
        String name = annotation.value();
        JavaScopeImpl scope = "COMPOSITE".equals(name) ? JavaScopeImpl.COMPOSITE : ("SESSION".equals(name) ? JavaScopeImpl.SESSION : ("CONVERSATION".equals(name) ? JavaScopeImpl.CONVERSATION : ("REQUEST".equals(name) ? JavaScopeImpl.REQUEST : new JavaScopeImpl(name))));
        type.setJavaScope(scope);
    }
}

