/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.core.invocation.CallbackInterfaceInterceptor;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;

public class JavaCallbackRuntimeWireProcessor
implements RuntimeWireProcessor {
    private static final Logger logger = Logger.getLogger(JavaCallbackRuntimeWireProcessor.class.getName());
    private InterfaceContractMapper interfaceContractMapper;
    private JavaInterfaceFactory javaInterfaceFactory;

    public JavaCallbackRuntimeWireProcessor(InterfaceContractMapper interfaceContractMapper, JavaInterfaceFactory javaInterfaceFactory) {
        this.interfaceContractMapper = interfaceContractMapper;
        this.javaInterfaceFactory = javaInterfaceFactory;
    }

    public void process(RuntimeWire wire) {
        this.addCallbackInterfaceInterceptors(wire);
    }

    private void addCallbackInterfaceInterceptors(RuntimeWire wire) {
        Interface iface;
        Contract contract = wire.getSource().getContract();
        if (!(contract instanceof RuntimeComponentReference)) {
            return;
        }
        RuntimeComponent component = wire.getSource().getComponent();
        Implementation implementation = component.getImplementation();
        if (!(implementation instanceof JavaImplementation)) {
            return;
        }
        JavaImplementation javaImpl = (JavaImplementation)implementation;
        EndpointReference callbackEndpoint = wire.getSource().getCallbackEndpoint();
        if (callbackEndpoint != null && !this.supportsCallbackInterface(iface = callbackEndpoint.getContract().getInterfaceContract().getInterface(), javaImpl)) {
            for (InvocationChain chain : wire.getInvocationChains()) {
                chain.addInterceptor("component.reference", (Interceptor)new CallbackInterfaceInterceptor());
            }
        }
    }

    private boolean supportsCallbackInterface(Interface iface, JavaImplementation impl) {
        Class<?> ifaceClass;
        if (iface instanceof JavaInterface && (ifaceClass = ((JavaInterface)iface).getJavaClass()).isAssignableFrom(impl.getJavaClass())) {
            return true;
        }
        try {
            JavaInterface implType = this.javaInterfaceFactory.createJavaInterface(impl.getJavaClass());
            implType.setRemotable(iface.isRemotable());
            implType.setConversational(iface.isConversational());
            return this.interfaceContractMapper.isCompatible(iface, implType);
        }
        catch (InvalidInterfaceException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }
}

