/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.context.ComponentContextImpl;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.core.invocation.CallableReferenceObjectFactory;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceObjectFactory;
import org.apache.tuscany.sca.core.invocation.CallbackWireObjectFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.WireObjectFactory;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.implementation.java.context.InstanceFactory;
import org.apache.tuscany.sca.implementation.java.impl.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.injection.ConversationIDObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.InvalidAccessorException;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.invocation.JavaImplementationInvoker;
import org.apache.tuscany.sca.implementation.java.invocation.JavaInstanceFactoryProvider;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.CallableReference;
import org.osoa.sca.annotations.ConversationID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaComponentContextProvider {
    private JavaPropertyValueObjectFactory propertyValueFactory;
    private DataBindingExtensionPoint dataBindingRegistry;
    private RuntimeComponent component;
    private JavaInstanceFactoryProvider<?> instanceFactoryProvider;
    private ProxyFactory proxyFactory;
    private InstanceFactory instanceFactory;

    public JavaComponentContextProvider(RuntimeComponent component, JavaInstanceFactoryProvider configuration, DataBindingExtensionPoint dataBindingExtensionPoint, PropertyValueFactory propertyValueObjectFactory, ComponentContextFactory componentContextFactory, RequestContextFactory requestContextFactory) {
        this.instanceFactoryProvider = configuration;
        this.proxyFactory = configuration.getProxyFactory();
        this.component = component;
        this.dataBindingRegistry = dataBindingExtensionPoint;
        this.propertyValueFactory = (JavaPropertyValueObjectFactory)propertyValueObjectFactory;
    }

    InstanceWrapper<?> createInstanceWrapper() throws ObjectCreationException {
        return this.instanceFactory.newInstance();
    }

    void configureProperties(List<ComponentProperty> definedProperties) {
        for (ComponentProperty p : definedProperties) {
            this.configureProperty(p);
        }
    }

    private void configureProperty(ComponentProperty configuredProperty) {
        JavaElementImpl element = this.instanceFactoryProvider.getImplementation().getPropertyMembers().get(configuredProperty.getName());
        if (element != null && configuredProperty.getValue() != null) {
            if (!(element.getAnchor() instanceof Constructor)) {
                if (element.getElementType() == ElementType.FIELD) {
                    this.instanceFactoryProvider.getInjectionSites().add(element);
                } else {
                    this.instanceFactoryProvider.getInjectionSites().add(element);
                }
            }
            ObjectFactory<?> propertyObjectFactory = this.createPropertyValueFactory(configuredProperty, configuredProperty.getValue(), element);
            this.instanceFactoryProvider.setObjectFactory(element, propertyObjectFactory);
            JavaConstructorImpl<?> constructor = this.instanceFactoryProvider.getImplementation().getConstructor();
            for (JavaParameterImpl p : constructor.getParameters()) {
                if (!element.getName().equals(p.getName())) continue;
                this.instanceFactoryProvider.setObjectFactory(p, propertyObjectFactory);
            }
        }
    }

    void start() {
        Class<?> businessInterface;
        if (!this.instanceFactoryProvider.getImplementation().getCallbackMembers().isEmpty()) {
            HashMap<String, List<RuntimeWire>> callbackWires = new HashMap<String, List<RuntimeWire>>();
            for (ComponentService componentService : this.component.getServices()) {
                List<RuntimeWire> wires;
                RuntimeComponentReference callbackReference = (RuntimeComponentReference)componentService.getCallbackReference();
                if (callbackReference == null || (wires = callbackReference.getRuntimeWires()).isEmpty()) continue;
                callbackWires.put(wires.get(0).getSource().getInterfaceContract().getInterface().toString(), wires);
            }
            for (Map.Entry entry : this.instanceFactoryProvider.getImplementation().getCallbackMembers().entrySet()) {
                List wires = (List)callbackWires.get(entry.getKey());
                if (wires == null) continue;
                for (JavaElementImpl element : (Collection)entry.getValue()) {
                    businessInterface = element.getType();
                    ObjectFactory<Object> factory = null;
                    if (CallableReference.class.isAssignableFrom(element.getType())) {
                        businessInterface = JavaIntrospectionHelper.getBusinessInterface(element.getType(), element.getGenericType());
                        factory = new CallbackReferenceObjectFactory(businessInterface, this.proxyFactory, wires);
                    } else {
                        factory = new CallbackWireObjectFactory(businessInterface, this.proxyFactory, wires);
                    }
                    if (!(element.getAnchor() instanceof Constructor)) {
                        this.instanceFactoryProvider.getInjectionSites().add(element);
                    }
                    this.instanceFactoryProvider.setObjectFactory(element, factory);
                }
            }
        }
        for (Reference ref : this.instanceFactoryProvider.getImplementation().getReferences()) {
            JavaElementImpl javaElementImpl = this.instanceFactoryProvider.getImplementation().getReferenceMembers().get(ref.getName());
            if (javaElementImpl == null) continue;
            if (!(javaElementImpl.getAnchor() instanceof Constructor)) {
                if (javaElementImpl.getElementType() == ElementType.FIELD) {
                    Field field = (Field)javaElementImpl.getAnchor();
                    if (Modifier.isPublic(field.getModifiers())) {
                        this.instanceFactoryProvider.getInjectionSites().add(javaElementImpl);
                    } else if (field.getAnnotation(org.osoa.sca.annotations.Reference.class) != null) {
                        this.instanceFactoryProvider.getInjectionSites().add(javaElementImpl);
                    }
                } else {
                    this.instanceFactoryProvider.getInjectionSites().add(javaElementImpl);
                }
            }
            ComponentReference componentReference = null;
            List<RuntimeWire> wireList = null;
            for (ComponentReference reference : this.component.getReferences()) {
                if (!reference.getName().equals(ref.getName())) continue;
                wireList = ((RuntimeComponentReference)reference).getRuntimeWires();
                componentReference = reference;
                break;
            }
            if (ref.getMultiplicity() == Multiplicity.ONE_N || ref.getMultiplicity() == Multiplicity.ZERO_N) {
                ArrayList factories = new ArrayList();
                Class<?> baseType = JavaIntrospectionHelper.getBaseType(javaElementImpl.getType(), javaElementImpl.getGenericType());
                for (int i = 0; i < wireList.size(); ++i) {
                    CallableReferenceObjectFactory factory = null;
                    if (CallableReference.class.isAssignableFrom(baseType)) {
                        Type callableRefType = JavaIntrospectionHelper.getParameterType(javaElementImpl.getGenericType());
                        Class<?> businessInterface2 = JavaIntrospectionHelper.getBusinessInterface(baseType, callableRefType);
                        factory = new CallableReferenceObjectFactory(businessInterface2, this.component, (RuntimeComponentReference)wireList.get(i).getSource().getContract(), wireList.get(i).getSource().getBinding());
                    } else {
                        factory = this.createObjectFactory(baseType, wireList.get(i));
                    }
                    factories.add(factory);
                }
                this.instanceFactoryProvider.setObjectFactories(javaElementImpl, factories);
                JavaConstructorImpl<?> constructor = this.instanceFactoryProvider.getImplementation().getConstructor();
                for (JavaParameterImpl p : constructor.getParameters()) {
                    if (!javaElementImpl.getName().equals(p.getName())) continue;
                    this.instanceFactoryProvider.setObjectFactories(p, factories);
                }
                continue;
            }
            if (wireList == null && ref.getMultiplicity() == Multiplicity.ONE_ONE) {
                throw new IllegalStateException("Required reference is missing: " + ref.getName());
            }
            if (wireList == null || wireList.isEmpty()) continue;
            CallableReferenceObjectFactory factory = null;
            if (CallableReference.class.isAssignableFrom(javaElementImpl.getType())) {
                businessInterface = JavaIntrospectionHelper.getBusinessInterface(javaElementImpl.getType(), javaElementImpl.getGenericType());
                factory = new CallableReferenceObjectFactory(businessInterface, this.component, (RuntimeComponentReference)componentReference, null);
            } else {
                factory = this.createObjectFactory(javaElementImpl.getType(), wireList.get(0));
            }
            this.instanceFactoryProvider.setObjectFactory(javaElementImpl, factory);
            JavaConstructorImpl<?> constructor = this.instanceFactoryProvider.getImplementation().getConstructor();
            for (JavaParameterImpl p : constructor.getParameters()) {
                if (!javaElementImpl.getName().equals(p.getName())) continue;
                this.instanceFactoryProvider.setObjectFactory(p, factory);
            }
        }
        ComponentContextImpl ccImpl = (ComponentContextImpl)this.component.getComponentContext();
        ccImpl.setPropertyValueFactory(this.propertyValueFactory);
        this.instanceFactory = this.instanceFactoryProvider.createFactory();
    }

    void addResourceFactory(String name, ObjectFactory<?> factory) {
        JavaResourceImpl resource = this.instanceFactoryProvider.getImplementation().getResources().get(name);
        if (resource != null && !(resource.getElement().getAnchor() instanceof Constructor)) {
            this.instanceFactoryProvider.getInjectionSites().add(resource.getElement());
        }
        this.instanceFactoryProvider.setObjectFactory(resource.getElement(), factory);
    }

    void addConversationIDFactories(List<Member> names) {
        ConversationIDObjectFactory factory = new ConversationIDObjectFactory();
        for (Member name : names) {
            JavaElementImpl element;
            if (name instanceof Field) {
                element = new JavaElementImpl((Field)name);
                element.setClassifer(ConversationID.class);
                this.instanceFactoryProvider.setObjectFactory(element, factory);
                continue;
            }
            if (name instanceof Method) {
                element = new JavaElementImpl((Method)name, 0);
                element.setName(JavaIntrospectionHelper.toPropertyName(name.getName()));
                element.setClassifer(ConversationID.class);
                this.instanceFactoryProvider.setObjectFactory(element, factory);
                continue;
            }
            throw new InvalidAccessorException("Member must be a field or method: " + name.getName());
        }
    }

    Object createInstance() throws ObjectCreationException {
        return this.createInstanceWrapper().getInstance();
    }

    JavaInstanceFactoryProvider<?> getInstanceFactoryProvider() {
        return this.instanceFactoryProvider;
    }

    void stop() {
    }

    Invoker createInvoker(Operation operation) throws NoSuchMethodException {
        Class<?> implClass = this.instanceFactoryProvider.getImplementationClass();
        Method method = JavaInterfaceUtil.findMethod(implClass, operation);
        return new JavaImplementationInvoker(operation, method, this.component);
    }

    private <B> ObjectFactory<B> createObjectFactory(Class<B> interfaze, RuntimeWire wire) {
        return new WireObjectFactory<B>(interfaze, wire, this.proxyFactory);
    }

    private ObjectFactory<?> createPropertyValueFactory(ComponentProperty property, Object propertyValue, JavaElementImpl javaElement) {
        return this.propertyValueFactory.createValueFactory((Property)property, propertyValue, javaElement);
    }

    RuntimeComponent getComponent() {
        return this.component;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OptimizedObjectFactory<T>
    implements ObjectFactory<T> {
        private ScopeContainer scopeContainer;

        public OptimizedObjectFactory(ScopeContainer scopeContainer) {
            this.scopeContainer = scopeContainer;
        }

        @Override
        public T getInstance() throws ObjectCreationException {
            try {
                return this.scopeContainer.getWrapper(null).getInstance();
            }
            catch (TargetResolutionException e) {
                throw new ObjectCreationException(e);
            }
        }
    }
}

