/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.jee.xml;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.EjbModuleInfo;
import org.apache.tuscany.sca.contribution.jee.ExternalEarInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEApplicationInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEExtension;
import org.apache.tuscany.sca.contribution.jee.JavaEEOptionalExtension;
import org.apache.tuscany.sca.contribution.jee.ModelObject;
import org.apache.tuscany.sca.contribution.jee.WebModuleInfo;
import org.apache.tuscany.sca.contribution.jee.impl.EjbModuleInfoImpl;
import org.apache.tuscany.sca.contribution.jee.impl.JavaEEApplicationInfoImpl;
import org.apache.tuscany.sca.contribution.jee.impl.ModelObjectImpl;
import org.apache.tuscany.sca.contribution.jee.impl.WebModuleInfoImpl;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.jee.JEEImplementation;
import org.apache.tuscany.sca.implementation.jee.JEEImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEEImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JEEImplementation> {
    private static final QName IMPLEMENTATION_JEE = new QName("http://www.osoa.org/xmlns/sca/1.0", "implementation.jee");
    private AssemblyFactory assemblyFactory;
    private PolicyFactory policyFactory;
    private JEEImplementationFactory implementationFactory;
    private JavaEEExtension jeeExtension;
    private JavaEEOptionalExtension jeeOptionalExtension;
    private Monitor monitor;
    private PolicyAttachPointProcessor policyProcessor;
    private StAXArtifactProcessorExtensionPoint artifactProcessors;
    private StAXArtifactProcessor<Composite> compositeProcessor;

    public JEEImplementationProcessor(ExtensionPointRegistry registry, Monitor monitor) {
        ModelFactoryExtensionPoint modelFactories = registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.implementationFactory = modelFactories.getFactory(JEEImplementationFactory.class);
        this.jeeExtension = modelFactories.getFactory(JavaEEExtension.class);
        this.jeeOptionalExtension = modelFactories.getFactory(JavaEEOptionalExtension.class);
        this.monitor = monitor;
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.artifactProcessors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.compositeProcessor = (StAXArtifactProcessor)this.artifactProcessors.getProcessor(Composite.class);
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_JEE;
    }

    @Override
    public Class<JEEImplementation> getModelType() {
        return JEEImplementation.class;
    }

    @Override
    public JEEImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        JEEImplementation implementation = this.implementationFactory.createJEEImplementation();
        implementation.setUnresolved(true);
        String archive = this.getString(reader, "archive");
        if (archive != null) {
            implementation.setArchive(archive);
            implementation.setURI(archive);
        }
        String path = URI.create(archive).getPath();
        String localName = "impl-jee-current-dir-archive";
        if (path != null) {
            int s = path.lastIndexOf(47);
            if (s > -1) {
                localName = path.substring(s + 1);
            } else if (path.length() > 0 && !path.equals(".")) {
                localName = path;
            }
        }
        QName name = new QName("http://tuscany.apache.org/xmlns/sca/1.0", localName);
        implementation.setName(name);
        this.policyProcessor.readPolicies(implementation, reader);
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_JEE.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(JEEImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        String uri = implementation.getURI();
        String archive = implementation.getArchive();
        if (uri != null) {
            Composite appComposite;
            Object resolved;
            Object unresolved;
            Object resolved2;
            Object unresolved2;
            Object moduleInfo = null;
            Object extEar = null;
            if (uri.equals("")) {
                if (moduleInfo == null) {
                    unresolved2 = new WebModuleInfoImpl();
                    unresolved2.setUri(URI.create(archive));
                    resolved2 = (WebModuleInfo)resolver.resolveModel(WebModuleInfo.class, unresolved2);
                    if (unresolved2 != resolved2) {
                        moduleInfo = resolved2;
                    }
                }
                if (moduleInfo == null) {
                    unresolved2 = new EjbModuleInfoImpl();
                    unresolved2.setUri(URI.create(archive));
                    resolved2 = (EjbModuleInfo)resolver.resolveModel(EjbModuleInfo.class, unresolved2);
                    if (unresolved2 != resolved2) {
                        moduleInfo = resolved2;
                    }
                }
                if (moduleInfo == null) {
                    unresolved2 = new JavaEEApplicationInfoImpl();
                    unresolved2.setUri(URI.create(archive));
                    resolved2 = (JavaEEApplicationInfo)resolver.resolveModel(JavaEEApplicationInfo.class, unresolved2);
                    if (unresolved2 != resolved2) {
                        moduleInfo = resolved2;
                    }
                }
            } else if (uri.endsWith(".war")) {
                WebModuleInfo webModuleInfo = new WebModuleInfoImpl();
                webModuleInfo.setUri(URI.create(archive));
                webModuleInfo = resolver.resolveModel(WebModuleInfo.class, webModuleInfo);
                moduleInfo = webModuleInfo;
            } else if (uri.endsWith(".jar")) {
                EjbModuleInfo ejbModuleInfo = new EjbModuleInfoImpl();
                ejbModuleInfo.setUri(URI.create(archive));
                ejbModuleInfo = resolver.resolveModel(EjbModuleInfo.class, ejbModuleInfo);
                moduleInfo = ejbModuleInfo;
            } else if (uri.endsWith(".ear")) {
                final JavaEEApplicationInfoImpl appInfo = new JavaEEApplicationInfoImpl();
                appInfo.setUri(URI.create(archive));
                unresolved = new ExternalEarInfo(){

                    public JavaEEApplicationInfo getAppInfo() {
                        return appInfo;
                    }

                    public Composite getAppComposite() {
                        return null;
                    }
                };
                resolved = (ExternalEarInfo)resolver.resolveModel(ExternalEarInfo.class, unresolved);
                if (resolved != unresolved) {
                    extEar = resolved;
                }
                moduleInfo = resolved.getAppInfo();
            }
            if (moduleInfo instanceof WebModuleInfo) {
                boolean includeDefaults;
                unresolved2 = new ModelObjectImpl();
                unresolved2.setUri(URI.create("WEB-INF/web.composite"));
                resolved2 = (ModelObject)resolver.resolveModel(ModelObject.class, unresolved2);
                if (resolved2 != unresolved2) {
                    appComposite = (Composite)resolved2.getObject();
                    this.mergeCompositeInfo(appComposite, implementation);
                }
                if ((includeDefaults = false) || resolved2 == unresolved2) {
                    if (this.jeeOptionalExtension != null) {
                        this.jeeOptionalExtension.createImplementationJeeComposite((WebModuleInfo)moduleInfo, (Composite)implementation);
                    }
                    this.compositeProcessor.resolve(implementation, resolver);
                }
            } else if (moduleInfo instanceof EjbModuleInfo) {
                boolean includeDefaults;
                unresolved2 = new ModelObjectImpl();
                unresolved2.setUri(URI.create("META-INF/ejb-jar.composite"));
                resolved2 = (ModelObject)resolver.resolveModel(ModelObject.class, unresolved2);
                if (resolved2 != unresolved2) {
                    appComposite = (Composite)resolved2.getObject();
                    this.mergeCompositeInfo(appComposite, implementation);
                }
                if ((includeDefaults = false) || resolved2 == unresolved2) {
                    if (this.jeeExtension != null) {
                        this.jeeExtension.createImplementationJeeComposite((EjbModuleInfo)moduleInfo, (Composite)implementation);
                    }
                    if (this.jeeOptionalExtension != null) {
                        this.jeeOptionalExtension.createImplementationJeeComposite((EjbModuleInfo)moduleInfo, (Composite)implementation);
                    }
                    this.compositeProcessor.resolve(implementation, resolver);
                }
            } else if (moduleInfo instanceof JavaEEApplicationInfo) {
                boolean includeDefaults;
                Composite appComposite2 = null;
                if (extEar != null) {
                    appComposite2 = extEar.getAppComposite();
                } else {
                    unresolved = new ModelObjectImpl();
                    unresolved.setUri(URI.create("META-INF/application.composite"));
                    resolved = (ModelObject)resolver.resolveModel(ModelObject.class, unresolved);
                    if (resolved != unresolved) {
                        appComposite2 = (Composite)resolved.getObject();
                    }
                }
                if (appComposite2 != null) {
                    this.mergeCompositeInfo(appComposite2, implementation);
                }
                if ((includeDefaults = false) || appComposite2 == null) {
                    if (this.jeeExtension != null) {
                        this.jeeExtension.createImplementationJeeComposite((JavaEEApplicationInfo)moduleInfo, (Composite)implementation);
                    }
                    if (this.jeeOptionalExtension != null) {
                        this.jeeOptionalExtension.createImplementationJeeComposite((JavaEEApplicationInfo)moduleInfo, (Composite)implementation);
                    }
                    this.compositeProcessor.resolve(implementation, resolver);
                }
            }
        }
        implementation.setUnresolved(false);
    }

    private void mergeCompositeInfo(Composite fromComposite, Composite intoComposite) {
        intoComposite.getApplicablePolicySets().addAll(fromComposite.getApplicablePolicySets());
        intoComposite.getAttributeExtensions().addAll(fromComposite.getAttributeExtensions());
        intoComposite.setAutowire(fromComposite.getAutowire());
        intoComposite.getComponents().addAll(fromComposite.getComponents());
        intoComposite.setConstrainingType(fromComposite.getConstrainingType());
        intoComposite.getExtensions().addAll(fromComposite.getExtensions());
        intoComposite.setLocal(fromComposite.isLocal());
        intoComposite.getIncludes().addAll(fromComposite.getIncludes());
        intoComposite.setName(fromComposite.getName());
        intoComposite.getPolicySets().addAll(fromComposite.getPolicySets());
        intoComposite.getProperties().addAll(fromComposite.getProperties());
        intoComposite.getReferences().addAll(fromComposite.getReferences());
        intoComposite.getRequiredIntents().addAll(fromComposite.getRequiredIntents());
        intoComposite.getServices().addAll(fromComposite.getServices());
        intoComposite.setType(fromComposite.getType());
        intoComposite.setUnresolved(fromComposite.isUnresolved());
        intoComposite.setURI(fromComposite.getURI());
        intoComposite.getWires().addAll(fromComposite.getWires());
    }

    @Override
    public void write(JEEImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, IMPLEMENTATION_JEE.getNamespaceURI(), IMPLEMENTATION_JEE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("archive", implementation.getArchive()));
        this.policyProcessor.writePolicyAttributes(implementation, writer);
        this.writeEnd(writer);
    }
}

