/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.node.manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.implementation.node.manager.NodeManagerUtil;
import org.apache.tuscany.sca.node.launcher.NodeLauncher;
import org.osoa.sca.ServiceRuntimeException;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(interfaces={ItemCollection.class, LocalItemCollection.class})
public class NodeProcessCollectionImpl
implements ItemCollection,
LocalItemCollection {
    private static final Logger logger = Logger.getLogger(NodeProcessCollectionImpl.class.getName());
    private List<SCANodeVM> nodeVMs = new ArrayList<SCANodeVM>();

    @Init
    public void initialize() {
    }

    @Override
    public Entry<String, Item>[] getAll() {
        logger.fine("getAll");
        ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
        for (SCANodeVM vm : this.nodeVMs) {
            entries.add(NodeProcessCollectionImpl.entry(vm));
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    @Override
    public Item get(String key) throws NotFoundException {
        logger.fine("get " + key);
        SCANodeVM vm = this.vm(key);
        if (vm == null) {
            throw new NotFoundException();
        }
        return NodeProcessCollectionImpl.item(vm);
    }

    @Override
    public String post(String key, Item item) {
        logger.fine("post " + key);
        SCANodeVM vm = this.vm(key);
        if (vm != null) {
            if (vm.isAlive()) {
                return key;
            }
            try {
                vm.stop();
            }
            catch (InterruptedException e) {
                throw new ServiceRuntimeException(e);
            }
            this.nodeVMs.remove(vm);
        }
        vm = new SCANodeVM(key);
        this.nodeVMs.add(0, vm);
        try {
            vm.start();
        }
        catch (IOException e) {
            throw new ServiceRuntimeException(e);
        }
        return key;
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String key) throws NotFoundException {
        logger.fine("delete " + key);
        SCANodeVM vm = this.vm(key);
        if (vm != null) {
            try {
                vm.stop();
            }
            catch (InterruptedException e) {
                throw new ServiceRuntimeException(e);
            }
            this.nodeVMs.remove(vm);
        }
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        logger.fine("query " + queryString);
        if (queryString.startsWith("node=")) {
            String key = queryString.substring(queryString.indexOf(61) + 1);
            ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
            for (SCANodeVM vm : this.nodeVMs) {
                if (!vm.getNodeName().equals(key)) continue;
                entries.add(NodeProcessCollectionImpl.entry(vm));
            }
            return entries.toArray(new Entry[entries.size()]);
        }
        throw new UnsupportedOperationException();
    }

    private SCANodeVM vm(String key) {
        for (SCANodeVM vm : this.nodeVMs) {
            if (!key.equals(vm.getNodeName())) continue;
            return vm;
        }
        return null;
    }

    private static Entry<String, Item> entry(SCANodeVM vm) {
        Entry<String, Item> entry = new Entry<String, Item>();
        entry.setKey(vm.getNodeName());
        entry.setData(NodeProcessCollectionImpl.item(vm));
        return entry;
    }

    private static Item item(SCANodeVM vm) {
        Item item = new Item();
        String key = vm.getNodeName();
        item.setTitle(NodeProcessCollectionImpl.title(key));
        item.setLink("/node-config/" + vm.getNodeName());
        item.setContents("<span id=\"log\" style=\"white-space: nowrap; font-size: small\">" + vm.getLog().toString() + "</span>");
        return item;
    }

    private static String title(String key) {
        return key;
    }

    private static class SCANodeVM {
        private String nodeName;
        private StringBuffer log = new StringBuffer();
        private Process process;
        private Thread monitor;
        private int status;

        SCANodeVM(String nodeName) {
            this.nodeName = nodeName;
        }

        private void start() throws IOException {
            String tuscanyPath;
            String nodeConfigurationURI = NodeManagerUtil.nodeConfigurationURI(this.nodeName);
            Properties props = System.getProperties();
            String java = props.getProperty("java.home") + "/bin/java";
            String cp = props.getProperty("java.class.path");
            String main = NodeLauncher.class.getName();
            ArrayList<String> command = new ArrayList<String>();
            command.add(java);
            command.add("-cp");
            command.add(cp);
            String tuscanyHome = props.getProperty("TUSCANY_HOME");
            if (tuscanyHome != null) {
                command.add("-DTUSCANY_HOME=" + tuscanyHome);
            }
            if ((tuscanyPath = props.getProperty("TUSCANY_PATH")) != null) {
                command.add("-DTUSCANY_PATH=" + tuscanyPath);
            }
            command.add(main);
            command.add(nodeConfigurationURI);
            logger.info("Starting java " + main + " " + nodeConfigurationURI);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            this.process = builder.start();
            logger.info("Started " + this.process);
            final BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.monitor = new Thread(new Runnable(){

                public void run() {
                    try {
                        String s;
                        while ((s = reader.readLine()) != null) {
                            logger.info(s);
                            SCANodeVM.this.log.append(s + "<br>");
                        }
                        SCANodeVM.this.status = SCANodeVM.this.process.waitFor();
                    }
                    catch (IOException e) {
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.monitor.start();
        }

        String getNodeName() {
            return this.nodeName;
        }

        StringBuffer getLog() {
            return this.log;
        }

        private boolean isAlive() {
            return this.monitor.isAlive();
        }

        int getStatus() {
            return this.status;
        }

        private void stop() throws InterruptedException {
            logger.info("Stopping " + this.process);
            this.process.destroy();
            this.monitor.join();
            logger.info("Stopped " + this.process);
        }
    }
}

